// Copyright (C) 1998-2000 EPITA-LRDE    
// EPITA Research and Development Laboratory

#include <iostream>
#include <time.h>
#include "aggregate.hh"
#include "iterator.hh"
#include "image2d.hh"
#include "image3d.hh"




template<class Data> 
void add( Aggregate<Data>& aggregate, Data val )
{
  Iterator<Data>& iter = aggregate.createIterator();
  for_each( iter )
    iter.value() += val;
}



template<class Data>
void mean( Aggregate<Data>& inputAggregate,
           Aggregate<Data>& outputAggregate )
{
  Iterator<Data>& inputElt = inputAggregate.createIterator();
  Iterator<Data>& outputElt = outputAggregate.createIterator();
  Iterator<Data>& neighborElt = inputElt.createNeighborIterator();

  for_each( inputElt )
    {
      Data sum = 0;
      for_each( neighborElt )
	sum += neighborElt.value();
      outputElt.value() = sum / neighborElt.getCard();
    }
}



int main()
{
  typedef signed char IntegerS8;
  const int n = 1;

  Image2D<IntegerS8> image( 2048, 4096 );
  //  Image3D<IntegerS8> image( 128, 256, 256 );

  image.prettify();
  IntegerS8 val = 1;
  
  {
    float t0 = (float)clock();
    for ( int i = 0; i < n; ++i )
      {
	add( image, val );
      }
    cout << "add (C++ classic): "
	 << ( clock() - t0 ) / CLOCKS_PER_SEC / n
	 << " s " << endl;
  }
  {
    float t0 = (float)clock();
    for ( int i = 0; i < n; ++i )
      {
	mean( image, image );
      }
    cout << "mean (C++ classic): "
	 << ( clock() - t0 ) / CLOCKS_PER_SEC / n
	 << " s " << endl;
  }

  return 0;
}
