// Copyright (C) 1998-2000 EPITA-LRDE    
// EPITA Research and Development Laboratory

#include <iostream>
#include <time.h>
#include "image2d.hh"
#include "image3d.hh"



#define  for_each( ITER )  for ( ITER.first(); ! ITER.isDone(); ITER.next() )



template<class Aggregate> 
void add( Aggregate& aggregate, typename Aggregate::DataType val )
{
  typename Aggregate::Iterator iter( aggregate );
  for_each( iter )
    iter.value() += val;
}



template<class T>
struct Cumul
{
};



template<>
struct Cumul< signed char >
{
  typedef signed short type;
};



template<class Aggregate>
void mean( Aggregate& inputAggregate,
           Aggregate& outputAggregate )
{
  typedef typename Aggregate::NeighborIterator			NeighborIterator;
  typedef typename Aggregate::Iterator				Iterator;
  typedef typename Cumul< typename Aggregate::DataType >::type	CumulType;

  Iterator		inputElt( inputAggregate );
  NeighborIterator	neighborElt( inputElt );
  Iterator		outputElt( outputAggregate );

  for_each( inputElt )
    {
      CumulType sum = 0;
      for_each( neighborElt )
	sum += neighborElt.value();
      outputElt.value() = sum / (NeighborIterator::card) ;
    }
}



int main()
{
  typedef signed char IntegerS8;
  const int n = 10;

  Image2D<IntegerS8> image( 2048, 4096 );
  // Image3D<IntegerS8> image( 128, 256, 256 );

  image.prettify();
  IntegerS8 val = 1;
  
  {
    float t0 = (float)clock();
    for ( int i = 0; i < n; ++i )
      {
	add( image, val );
      }
    cout << "add (C++ generic w/ offsets): "
	 << ( clock() - t0 ) / CLOCKS_PER_SEC / n
	 << " s " << endl;
  }
  {
    float t0 = (float)clock();
    for ( int i = 0; i < n; ++i )
      {
	mean( image, image );
      }
    cout << "mean (C++ generic w/ offsets): "
	 << ( clock() - t0 ) / CLOCKS_PER_SEC / n
	 << " s " << endl;
  }

  return 0;
}
