/*
 *  file gamma_bridge.cc
 *
 *  Copyright (C) 1999 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */

#include <iostream>



// --------------------------  Implementor



class Implementor
{
public:
  virtual void OperationImp() = 0;
};


// --------------------------  Abstraction


class Abstraction
{
public:
  Abstraction( Implementor* imp_ ) :
    imp( imp_ )
  {
  }
  void Operation()
  {
    imp->OperationImp();
  }
protected:
  Implementor* imp;
};



// --------------------------  RefinedAbstraction



class RefinedAbstraction : public Abstraction
{
public:
  RefinedAbstraction( Implementor* imp_ ) :
    Abstraction( imp_ )
  {
  }
};



// --------------------------  ConcreteImplementorA



class ConcreteImplementorA : public Implementor
{
public:
  virtual void OperationImp()
  {
    std::cout << "ConcreteImplementorA::OperationImp" << std::endl;
  }
};



// --------------------------  ConcreteImplementorB



class ConcreteImplementorB : public Implementor
{
public:
  virtual void OperationImp()
  {
    std::cout << "ConcreteImplementorB::OperationImp" << std::endl;
  }
};



// --------------------------  main



int main()
{
  RefinedAbstraction obj( new ConcreteImplementorA() );
  obj.Operation();
}
