/*
 *  file generic_chain.cc
 *
 *  Copyright (C) 1999 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */

#include <iostream>



// --------------------------  Stopper


class Stopper
{
public:
  void HandleRequest()
  {
  }
};



// --------------------------  ConcreteHandler1


template< typename H >
class ConcreteHandler1
{
public:
  ConcreteHandler1( H* successor = 0 )
  {
    this->successor = successor;
  }
  void HandleRequest()
  {
    std::cout << "ConcreteHandler1::HandleRequest" << std::endl;
    if ( successor )
      successor->HandleRequest();
  }
protected:
  H* successor;
};



// --------------------------  ConcreteHandler2



template< typename H >
class ConcreteHandler2
{
public:
  ConcreteHandler2( H* successor = 0 )
  {
    this->successor = successor;
  }
  void HandleRequest()
  {
    std::cout << "ConcreteHandler2::HandleRequest" << std::endl;
    if ( successor )
      successor->HandleRequest();
  }
protected:
  H* successor;
};



// --------------------------  main



int main()
{
  typedef ConcreteHandler2< Stopper > Handler2;
  typedef ConcreteHandler1< Handler2 > Handler1;
  typedef Handler1 Handler;
  Handler* h = new Handler1( new Handler2() );
  h->HandleRequest();
}
