/*
 *  file gamma_template_method.cc
 *
 *  Copyright (C) 1999 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */

#include <iostream>



// --------------------------  AbstractClass



class AbstractClass
{
public:
  void TemplateMethod()
    {
      // ...
      PrimitiveOperation1();
      // ...
      PrimitiveOperation2();
      // ...
    }
  virtual void PrimitiveOperation1() = 0;
  virtual void PrimitiveOperation2() = 0;
};



// --------------------------  ConcreteClass



class ConcreteClass : public AbstractClass
{
public:
  virtual void PrimitiveOperation1()
    {
      std::cout << "ConcreteClass::PrimitiveOperation1" << std::endl;
    }
  virtual void PrimitiveOperation2()
    {
      std::cout << "ConcreteClass::PrimitiveOperation2" << std::endl;
    }
};



// --------------------------  main



int main()
{
  ConcreteClass obj;
  obj.TemplateMethod();
}
