/*
 *  file proxy.cc
 *
 *  Copyright (C) 2000 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */

#include <iostream>



// concept definition


template< class ModelA >
struct ConceptA
{
  ConceptA( ModelA& model ) : _model( model )
  {
    std::cout << "proxy ctor" << std::endl;
  }
  void meth() { _model.meth(); }
  ModelA& _model;
};



// generic procedure and its facade


template< class ModelA >
void foo_impl( ConceptA< ModelA > data )
{
  data.meth();
}


template< class ModelA >
void foo( ModelA& data )
{
  foo_impl( ConceptA< ModelA >( data ) );
}



// model


struct A1
{
  void meth()
  {
    std::cout << "A1::meth()" << std::endl;
  }
};



// main


int main()
{
  A1 a;
  foo( a );
}
