/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.jxp.parser;

import org.onemind.jxp.parser.JxpParser;
import org.onemind.jxp.parser.JxpParserTreeConstants;
import org.onemind.jxp.parser.JxpParserVisitor;
import org.onemind.jxp.parser.Node;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected JxpParser parser;
    int _dim;
    int _line;
    int _col;
    protected Object _data;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(JxpParser p, int i) {
        this(i);
        this.parser = p;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Object jjtAccept(JxpParserVisitor visitor, Object data) throws Exception {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(JxpParserVisitor visitor, Object data) throws Exception {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].jjtAccept(visitor, data);
            }
        }
        return data;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(JxpParserTreeConstants.jjtNodeName[this.id]);
        if (this._data != null) {
            sb.append(": " + this._data);
        }
        return sb.toString();
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix) + " - (" + this._line + ", " + this._col + ")");
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    public int getCol() {
        return this._col;
    }

    public Object getData() {
        return this._data;
    }

    public int getLine() {
        return this._line;
    }

    public void setCol(int i) {
        this._col = i;
    }

    public void setData(Object object) {
        this._data = object;
    }

    public void setLine(int i) {
        this._line = i;
    }
}

