/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.jbdd;

import java.util.BitSet;
import javax.annotation.Nonnegative;

public final class BitUtil {
    private BitUtil() {
    }

    public static boolean areAllSet(long store, BitSet pos) {
        if (pos.length() >= 64) {
            return false;
        }
        int i = pos.nextSetBit(0);
        while (i >= 0) {
            if (!BitUtil.isSet(store, i)) {
                return false;
            }
            i = pos.nextSetBit(i + 1);
        }
        return true;
    }

    public static long clear(long store, @Nonnegative int length, @Nonnegative int at) {
        return store & (BitUtil.maskLength(length, at) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long clear(long store, @Nonnegative int length) {
        return store & (BitUtil.maskLength(length) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static boolean fits(int value, @Nonnegative int bitSize) {
        return BitUtil.fits((long)value, bitSize);
    }

    public static boolean fits(long value, @Nonnegative int bitSize) {
        return value <= BitUtil.maskLength(bitSize);
    }

    public static long get(long store, @Nonnegative int length) {
        return store & BitUtil.maskLength(length);
    }

    public static long get(long store, @Nonnegative int length, @Nonnegative int at) {
        return store >>> at & BitUtil.maskLength(length);
    }

    public static long getBit(long store, @Nonnegative int at) {
        return store >> at & 1L;
    }

    public static long getFirstBit(long store) {
        return store & 1L;
    }

    public static long getHead(long store, @Nonnegative int at) {
        return store >>> at;
    }

    public static int intMaskLength(@Nonnegative int length) {
        return (1 << length) - 1;
    }

    public static boolean isAnySet(long store, BitSet pos) {
        int i = pos.nextSetBit(0);
        while (i >= 0 && i < 64) {
            if (BitUtil.isSet(store, i)) {
                return true;
            }
            i = pos.nextSetBit(i + 1);
        }
        return false;
    }

    public static boolean isSet(long store, @Nonnegative int pos) {
        assert (0 <= pos && pos < 64);
        return (store >>> pos & 1L) != 0L;
    }

    public static long maskLength(@Nonnegative int length) {
        return (1L << length) - 1L;
    }

    public static long maskLength(@Nonnegative int length, @Nonnegative int startingAt) {
        return BitUtil.maskLength(length) << startingAt;
    }

    public static int nextSetBit(long store, @Nonnegative int position) {
        for (int pos = position; pos < 64; ++pos) {
            if (!BitUtil.isSet(store, pos)) continue;
            return pos;
        }
        return -1;
    }

    public static long set(long store, long value, int length, @Nonnegative int at) {
        assert (value <= BitUtil.maskLength(length)) : "Bit size exceeded";
        return BitUtil.clear(store, length, at) | value << at;
    }

    public static long set(long store, long value, @Nonnegative int length) {
        assert (value <= BitUtil.maskLength(length)) : "Bit size exceeded";
        return BitUtil.clear(store, length) | value;
    }

    public static long setBit(long store, @Nonnegative int at) {
        return store | 1L << at;
    }

    public static long setFirstBit(long store) {
        return store | 1L;
    }

    public static long unsetBit(long store, @Nonnegative int at) {
        return store & (1L << at ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long unsetFirstBit(long store) {
        return store & 0xFFFFFFFFFFFFFFFEL;
    }
}

