/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.unionfind;

import de.tum.in.naturals.unionfind.IntUnionFind;
import java.util.Arrays;

public class IntArrayUnionFind
implements IntUnionFind {
    private int componentCount;
    private int[] parent;
    private int[] size;

    public IntArrayUnionFind(int size) {
        this.parent = new int[size];
        this.size = new int[size];
        this.componentCount = size;
        for (int i = 0; i < size; ++i) {
            this.parent[i] = i;
        }
        Arrays.fill(this.size, 1);
    }

    @Override
    public void add(int num) {
        this.componentCount += num;
        int currentSize = this.parent.length;
        int newSize = currentSize + num;
        this.parent = Arrays.copyOf(this.parent, newSize);
        this.size = Arrays.copyOf(this.parent, newSize);
        for (int i = currentSize; i < newSize; ++i) {
            this.parent[i] = i;
            this.size[i] = 1;
        }
    }

    @Override
    public int componentCount() {
        return this.componentCount;
    }

    @Override
    public int find(int p) {
        assert (this.isValid(p));
        int root = p;
        while (root != this.parent[root]) {
            root = this.parent[root];
        }
        int current = p;
        while (current != root) {
            int newParent = this.parent[current];
            this.parent[current] = root;
            current = newParent;
        }
        return root;
    }

    private boolean isValid(int p) {
        return 0 <= p && p < this.size();
    }

    @Override
    public int size() {
        return this.parent.length;
    }

    @Override
    public void union(int p, int q) {
        int rootQ;
        int rootP = this.find(p);
        if (rootP == (rootQ = this.find(q))) {
            return;
        }
        int sizeP = this.size[rootP];
        int sizeQ = this.size[rootQ];
        if (sizeP < sizeQ) {
            this.parent[rootP] = rootQ;
            this.size[rootQ] = sizeP + sizeQ;
        } else {
            this.parent[rootQ] = rootP;
            this.size[rootP] = sizeP + sizeQ;
        }
        --this.componentCount;
    }
}

