/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.consumer;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.consumer.HOAConsumerFactory;
import jhoafparser.consumer.HOAIntermediate;
import jhoafparser.util.AcceptanceRepositoryStandard;
import jhoafparser.util.ImplicitEdgeHelper;

public class HOAIntermediateCheckValidity
extends HOAIntermediate {
    protected boolean flagRejectSemanticMiscHeaders = false;
    protected HashSet<String> supportedMiscHeaders = null;
    protected HashSet<String> usedHeaders = new HashSet();
    protected Integer numberOfStates = null;
    protected Integer numberOfAcceptanceSets = null;
    protected BitSet statesWithDefinition = new BitSet();
    protected BitSet targetStatesOfTransitions = new BitSet();
    protected BitSet startStates = new BitSet();
    protected HashSet<String> aliases = new HashSet();
    protected BitSet apsInAliases = new BitSet();
    protected Integer numberOfAPs = null;
    protected String accName = null;
    protected List<Object> accExtraInfo = null;
    protected BooleanExpression<AtomAcceptance> acceptance = null;
    protected int currentState = 0;
    protected boolean currentStateHasStateLabel = false;
    protected boolean currentStateHasTransitionLabel = false;
    protected boolean currentStateHasImplicitEdge = false;
    protected boolean currentStateHasExplicitEdge = false;
    protected boolean currentStateHasStateAcceptance = false;
    protected boolean currentStateHasTransitionAcceptance = false;
    protected boolean currentStateIsColored;
    protected ImplicitEdgeHelper implicitEdgeHelper = null;
    protected boolean property_state_labels = false;
    protected boolean property_trans_labels = false;
    protected boolean property_implicit_labels = false;
    protected boolean property_explicit_labels = false;
    protected boolean property_state_acc = false;
    protected boolean property_trans_acc = false;
    protected boolean property_univ_branch = false;
    protected boolean property_no_univ_branch = false;
    protected boolean property_deterministic = false;
    protected boolean property_complete = false;
    protected boolean property_colored = false;
    protected int numberOfStartHeaders = 0;
    protected boolean hasUniversalBranching = false;

    public HOAIntermediateCheckValidity(HOAConsumer next) {
        super(next);
    }

    public static HOAConsumerFactory getFactory(final HOAConsumerFactory next) {
        return new HOAConsumerFactory(){

            @Override
            public HOAConsumer getNewHOAConsumer() {
                return new HOAIntermediateCheckValidity(next.getNewHOAConsumer());
            }
        };
    }

    public void setFlagRejectSemanticMiscHeaders(boolean value) {
        this.flagRejectSemanticMiscHeaders = value;
    }

    public void setSupportedMiscHeaders(HashSet<String> supportedMiscHeaders) {
        this.supportedMiscHeaders = supportedMiscHeaders;
    }

    public void addSupportedMiscHeader(String supportedMiscHeader) {
        if (this.supportedMiscHeaders == null) {
            this.supportedMiscHeaders = new HashSet();
        }
        this.supportedMiscHeaders.add(supportedMiscHeader);
    }

    @Override
    public boolean parserResolvesAliases() {
        return this.next.parserResolvesAliases();
    }

    @Override
    public void notifyHeaderStart(String version) throws HOAConsumerException {
        if (!version.equals("v1")) {
            throw new HOAConsumerException("Can only parse HOA format v1");
        }
        this.next.notifyHeaderStart(version);
    }

    @Override
    public void setNumberOfStates(int numberOfStates) throws HOAConsumerException {
        this.headerAtMostOnce("States");
        this.numberOfStates = numberOfStates;
        this.next.setNumberOfStates(numberOfStates);
    }

    @Override
    public void addStartStates(List<Integer> stateConjunction) throws HOAConsumerException {
        ++this.numberOfStartHeaders;
        if (stateConjunction.size() > 1) {
            this.hasUniversalBranching = true;
        }
        for (Integer state : stateConjunction) {
            this.checkStateIndex(state);
            this.startStates.set(state);
        }
        this.next.addStartStates(stateConjunction);
    }

    @Override
    public void addAlias(String name, BooleanExpression<AtomLabel> labelExpr) throws HOAConsumerException {
        this.usedHeaders.add("Alias");
        this.checkAliasesAreDefined(labelExpr);
        this.aliases.add(name);
        this.gatherLabels(labelExpr, this.apsInAliases);
        this.next.addAlias(name, labelExpr);
    }

    @Override
    public void setAPs(List<String> aps) throws HOAConsumerException {
        this.headerAtMostOnce("AP");
        this.numberOfAPs = aps.size();
        HashSet<String> apSet = new HashSet<String>();
        for (String ap : aps) {
            if (apSet.add(ap)) continue;
            throw new HOAConsumerException("Atomic proposition " + ap + " appears more than once in AP-header");
        }
        this.next.setAPs(aps);
    }

    @Override
    public void setAcceptanceCondition(int numberOfSets, BooleanExpression<AtomAcceptance> accExpr) throws HOAConsumerException {
        this.headerAtMostOnce("Acceptance");
        this.numberOfAcceptanceSets = numberOfSets;
        this.checkAcceptanceCondition(accExpr);
        this.acceptance = accExpr.clone();
        this.next.setAcceptanceCondition(numberOfSets, accExpr);
    }

    @Override
    public void provideAcceptanceName(String name, List<Object> extraInfo) throws HOAConsumerException {
        this.headerAtMostOnce("acc-name");
        this.accName = name;
        this.accExtraInfo = extraInfo;
        this.next.provideAcceptanceName(name, extraInfo);
    }

    @Override
    public void setName(String name) throws HOAConsumerException {
        this.headerAtMostOnce("name");
        this.next.setName(name);
    }

    @Override
    public void setTool(String name, String version) throws HOAConsumerException {
        this.headerAtMostOnce("tool");
        this.next.setTool(name, version);
    }

    @Override
    public void addProperties(List<String> properties) throws HOAConsumerException {
        this.usedHeaders.add("properties");
        Iterator<String> iterator = properties.iterator();
        while (iterator.hasNext()) {
            String property;
            switch (property = iterator.next()) {
                case "state_labels": {
                    this.property_state_labels = true;
                    break;
                }
                case "trans_labels": {
                    this.property_trans_labels = true;
                    break;
                }
                case "implicit_labels": {
                    this.property_implicit_labels = true;
                    break;
                }
                case "explicit_labels": {
                    this.property_explicit_labels = true;
                    break;
                }
                case "state_acc": {
                    this.property_state_acc = true;
                    break;
                }
                case "trans_acc": {
                    this.property_trans_acc = true;
                    break;
                }
                case "univ_branch": {
                    this.property_univ_branch = true;
                    break;
                }
                case "no_univ_branch": {
                    this.property_no_univ_branch = true;
                    break;
                }
                case "deterministic": {
                    this.property_deterministic = true;
                    break;
                }
                case "complete": {
                    this.property_complete = true;
                    break;
                }
                case "colored": {
                    this.property_colored = true;
                    break;
                }
            }
        }
        this.next.addProperties(properties);
    }

    @Override
    public void addMiscHeader(String name, List<Object> content) throws HOAConsumerException {
        this.usedHeaders.add(name);
        char firstCharacter = name.charAt(0);
        if (firstCharacter >= 'A' && firstCharacter <= 'Z' && this.flagRejectSemanticMiscHeaders && (this.supportedMiscHeaders == null || !this.supportedMiscHeaders.contains(name))) {
            throw new HOAConsumerException("Header " + name + " potentially has semantic relevance, but is not supported");
        }
        this.next.addMiscHeader(name, content);
    }

    @Override
    public void notifyBodyStart() throws HOAConsumerException {
        int highestAPIndex;
        this.headerIsMandatory("Acceptance");
        if (this.numberOfAPs == null) {
            this.numberOfAPs = 0;
        }
        if ((highestAPIndex = this.apsInAliases.length() - 1) >= 0 && highestAPIndex >= this.numberOfAPs) {
            throw new HOAConsumerException("AP index " + highestAPIndex + " in some alias definition is out of range" + (String)(this.numberOfAPs == 0 ? "(there are no APs)" : "(0 - " + (this.numberOfAPs - 1) + ")"));
        }
        if (this.accName != null) {
            this.checkAccName();
        }
        if (this.property_no_univ_branch && this.hasUniversalBranching) {
            throw new HOAConsumerException("Property 'no_univ_branching' is violated by the start states");
        }
        if (this.property_deterministic && this.numberOfStartHeaders != 1) {
            throw new HOAConsumerException("Property 'deterministic' is violated by having " + this.numberOfStartHeaders + " Start-headers");
        }
        this.implicitEdgeHelper = new ImplicitEdgeHelper(this.numberOfAPs);
        this.next.notifyBodyStart();
    }

    @Override
    public void addState(int id, String info, BooleanExpression<AtomLabel> labelExpr, List<Integer> accSignature) throws HOAConsumerException {
        this.checkStateIndex(id);
        if (this.statesWithDefinition.get(id)) {
            throw new HOAConsumerException("State " + id + " is defined multiple times");
        }
        this.statesWithDefinition.set(id);
        this.currentState = id;
        if (accSignature != null) {
            this.checkAcceptanceSignature(accSignature, false);
            this.currentStateIsColored = accSignature.size() == 1;
        } else {
            this.currentStateIsColored = false;
        }
        if (this.property_colored && this.numberOfAcceptanceSets > 0 && !this.currentStateIsColored && this.property_state_acc) {
            throw new HOAConsumerException("State " + id + " is not colored");
        }
        if (labelExpr != null) {
            this.checkLabelExpression(labelExpr);
        }
        this.currentStateHasStateLabel = labelExpr != null;
        this.currentStateHasTransitionLabel = false;
        this.currentStateHasImplicitEdge = false;
        this.currentStateHasExplicitEdge = false;
        this.currentStateHasStateAcceptance = accSignature != null;
        this.currentStateHasTransitionAcceptance = false;
        this.implicitEdgeHelper.startOfState(id);
        this.next.addState(id, info, labelExpr, accSignature);
    }

    @Override
    public void addEdgeImplicit(int stateId, List<Integer> conjSuccessors, List<Integer> accSignature) throws HOAConsumerException {
        assert (stateId == this.currentState);
        for (Integer succ : conjSuccessors) {
            this.checkStateIndexTarget(succ);
        }
        if (conjSuccessors.size() > 1) {
            this.hasUniversalBranching = true;
        }
        boolean edgeIsColored = false;
        if (accSignature != null) {
            this.checkAcceptanceSignature(accSignature, true);
            boolean bl = edgeIsColored = accSignature.size() == 1;
        }
        if (this.property_colored && this.numberOfAcceptanceSets > 0) {
            if (!this.currentStateIsColored && !edgeIsColored) {
                throw new HOAConsumerException("In state " + stateId + ", there is a transition that is not colored...");
            }
            if (this.currentStateIsColored && edgeIsColored) {
                throw new HOAConsumerException("In state " + stateId + ", there is a transition that is colored even though the state is colored already...");
            }
        }
        if (this.currentStateHasExplicitEdge) {
            throw new HOAConsumerException("Can not mix explicit and implicit edge definitions (state " + stateId + ")");
        }
        this.currentStateHasImplicitEdge = true;
        this.currentStateHasTransitionLabel = true;
        if (this.currentStateHasStateLabel) {
            throw new HOAConsumerException("Can not mix state labels and implicit edge definitions (state " + stateId + ")");
        }
        this.implicitEdgeHelper.nextImplicitEdge();
        this.next.addEdgeImplicit(stateId, conjSuccessors, accSignature);
    }

    @Override
    public void addEdgeWithLabel(int stateId, BooleanExpression<AtomLabel> labelExpr, List<Integer> conjSuccessors, List<Integer> accSignature) throws HOAConsumerException {
        assert (stateId == this.currentState);
        for (Integer succ : conjSuccessors) {
            this.checkStateIndexTarget(succ);
        }
        if (conjSuccessors.size() > 1) {
            this.hasUniversalBranching = true;
        }
        boolean edgeIsColored = false;
        if (accSignature != null) {
            this.checkAcceptanceSignature(accSignature, true);
            boolean bl = edgeIsColored = accSignature.size() == 1;
        }
        if (this.property_colored && this.numberOfAcceptanceSets > 0) {
            if (!this.currentStateIsColored && !edgeIsColored) {
                throw new HOAConsumerException("In state " + stateId + ", there is a transition that is not colored...");
            }
            if (this.currentStateIsColored && edgeIsColored) {
                throw new HOAConsumerException("In state " + stateId + ", there is a transition that is colored even though the state is colored already...");
            }
        }
        if (labelExpr != null) {
            this.checkLabelExpression(labelExpr);
        }
        if (labelExpr != null) {
            this.currentStateHasTransitionLabel = true;
            if (this.currentStateHasStateLabel) {
                throw new HOAConsumerException("Can not mix state and transition labeling (state " + stateId + ")");
            }
        }
        if (this.currentStateHasImplicitEdge) {
            throw new HOAConsumerException("Can not mix explicit and implicit edge definitions (state " + stateId + ")");
        }
        this.currentStateHasExplicitEdge = true;
        this.next.addEdgeWithLabel(stateId, labelExpr, conjSuccessors, accSignature);
    }

    @Override
    public void notifyEndOfState(int stateId) throws HOAConsumerException {
        this.implicitEdgeHelper.endOfState();
        if (this.property_state_labels && this.currentStateHasTransitionLabel) {
            throw new HOAConsumerException("Property 'state-labels' is violated by having transition labels in state " + stateId);
        }
        if (this.property_trans_labels && this.currentStateHasStateLabel) {
            throw new HOAConsumerException("Property 'trans-labels' is violated by having a state label in state " + stateId);
        }
        if (this.property_implicit_labels && this.currentStateHasExplicitEdge) {
            throw new HOAConsumerException("Property 'implicit-label' is violated by having a label expression on a transition in state " + stateId);
        }
        if (this.property_explicit_labels && this.currentStateHasImplicitEdge) {
            throw new HOAConsumerException("Property 'explicit-label' is violated by having implicit transition(s) in state " + stateId);
        }
        if (this.property_state_acc && this.currentStateHasTransitionAcceptance) {
            throw new HOAConsumerException("Property 'state-acc' is violated by having transition acceptance in state " + stateId);
        }
        if (this.property_trans_acc && this.currentStateHasStateAcceptance) {
            throw new HOAConsumerException("Property 'trans-acc' is violated by having state acceptance in state " + stateId);
        }
        if (this.property_no_univ_branch && this.hasUniversalBranching) {
            throw new HOAConsumerException("Property 'no-univ-branch' is violated by having universal branching in state " + stateId);
        }
        this.next.notifyEndOfState(stateId);
    }

    @Override
    public void notifyEnd() throws HOAConsumerException {
        this.checkStates();
        if (this.property_univ_branch && !this.hasUniversalBranching) {
            throw new HOAConsumerException("Property 'univ-branch' is violated by not having universal branching in the automaton");
        }
        this.next.notifyEnd();
    }

    @Override
    public void notifyAbort() {
        this.next.notifyAbort();
    }

    private void doWarning(String warning) throws HOAConsumerException {
        this.next.notifyWarning(warning);
    }

    private void headerIsMandatory(String name) throws HOAConsumerException {
        if (!this.usedHeaders.contains(name)) {
            throw new HOAConsumerException("Mandatory header " + name + " is missing");
        }
    }

    private void headerAtMostOnce(String headerName) throws HOAConsumerException {
        if (this.usedHeaders.contains(headerName)) {
            throw new HOAConsumerException("Header " + headerName + " occurs multiple times, but is allowed only once.");
        }
        this.usedHeaders.add(headerName);
    }

    private void checkStateIndex(int index) throws HOAConsumerException {
        if (index < 0) {
            throw new HOAConsumerException("State index " + index + " is negative");
        }
        if (this.numberOfStates != null && index >= this.numberOfStates) {
            throw new HOAConsumerException("State index " + index + " is out of range (0 - " + (this.numberOfStates - 1) + ")");
        }
    }

    private void checkStateIndexTarget(int index) throws HOAConsumerException {
        if (index < 0) {
            throw new HOAConsumerException("State index " + index + " is negative");
        }
        if (this.numberOfStates != null && index >= this.numberOfStates) {
            throw new HOAConsumerException("State index " + index + " is out of range (0 - " + (this.numberOfStates - 1) + ")");
        }
        this.targetStatesOfTransitions.set(index);
    }

    private void checkStates() throws HOAConsumerException {
        boolean haveComplainedAboutMissingStates = false;
        if (this.numberOfStates != null) {
            int highestStateIndex = this.statesWithDefinition.length() - 1;
            if (highestStateIndex >= this.numberOfStates) {
                throw new HOAConsumerException("State index " + highestStateIndex + " is out of range (0 - " + (this.numberOfStates - 1) + ")");
            }
            highestStateIndex = this.targetStatesOfTransitions.length() - 1;
            if (highestStateIndex >= this.numberOfStates) {
                throw new HOAConsumerException("State index " + highestStateIndex + " (target in a transition) is out of range (0 - " + (this.numberOfStates - 1) + ")");
            }
            highestStateIndex = this.startStates.length() - 1;
            if (highestStateIndex >= this.numberOfStates) {
                throw new HOAConsumerException("State index " + highestStateIndex + " (start state) is out of range (0 - " + (this.numberOfStates - 1) + ")");
            }
            if (this.statesWithDefinition.cardinality() != this.numberOfStates.intValue()) {
                int missing = this.numberOfStates - this.statesWithDefinition.cardinality();
                this.doWarning("There are " + missing + " states without definition");
                haveComplainedAboutMissingStates = true;
            }
        }
        BitSet targetsButNoDefinition = (BitSet)this.targetStatesOfTransitions.clone();
        targetsButNoDefinition.andNot(this.statesWithDefinition);
        if (!targetsButNoDefinition.isEmpty() && !haveComplainedAboutMissingStates) {
            this.doWarning("There are " + targetsButNoDefinition.cardinality() + " states that are targets of transitions but that have no definition");
            haveComplainedAboutMissingStates = true;
        }
        BitSet startStatesButNoDefinition = (BitSet)this.startStates.clone();
        startStatesButNoDefinition.andNot(this.statesWithDefinition);
        if (!startStatesButNoDefinition.isEmpty() && !haveComplainedAboutMissingStates) {
            this.doWarning("There are " + startStatesButNoDefinition.cardinality() + " states that are start states but that have no definition");
            haveComplainedAboutMissingStates = true;
        }
        if (haveComplainedAboutMissingStates && this.property_colored && this.numberOfAcceptanceSets > 0) {
            throw new HOAConsumerException("An automaton with property 'colored' can not have states missing a definition");
        }
    }

    private void checkAcceptanceCondition(BooleanExpression<AtomAcceptance> accExpr) throws HOAConsumerException {
        assert (this.numberOfAcceptanceSets != null);
        switch (accExpr.getType()) {
            case EXP_TRUE: 
            case EXP_FALSE: {
                return;
            }
            case EXP_AND: 
            case EXP_OR: {
                this.checkAcceptanceCondition(accExpr.getLeft());
                this.checkAcceptanceCondition(accExpr.getRight());
                return;
            }
            case EXP_NOT: {
                throw new HOAConsumerException("Acceptance condition contains boolean negation, not allowed");
            }
            case EXP_ATOM: {
                int acceptanceSet = accExpr.getAtom().getAcceptanceSet();
                if (acceptanceSet < 0 || acceptanceSet >= this.numberOfAcceptanceSets) {
                    throw new HOAConsumerException("Acceptance condition contains acceptance set with index " + acceptanceSet + ", valid range is 0 - " + (this.numberOfAcceptanceSets - 1));
                }
                return;
            }
        }
        throw new UnsupportedOperationException("Unknown operator in acceptance condition: " + accExpr);
    }

    private void checkAcceptanceSignature(List<Integer> accSignature, boolean inTransition) throws HOAConsumerException {
        for (Integer acceptanceSet : accSignature) {
            if (acceptanceSet >= 0 && acceptanceSet < this.numberOfAcceptanceSets) continue;
            throw new HOAConsumerException("Acceptance signature " + (inTransition ? "(in transition) " : "") + "for state index " + this.currentState + " contains acceptance set with index " + acceptanceSet + (String)(this.numberOfAcceptanceSets == 0 ? ", but there are not acceptance sets" : ", valid range is 0 - " + (this.numberOfAcceptanceSets - 1)));
        }
    }

    private void checkAliasesAreDefined(BooleanExpression<AtomLabel> expr) throws HOAConsumerException {
        switch (expr.getType()) {
            case EXP_TRUE: 
            case EXP_FALSE: {
                return;
            }
            case EXP_AND: 
            case EXP_OR: {
                this.checkAliasesAreDefined(expr.getLeft());
                this.checkAliasesAreDefined(expr.getRight());
                return;
            }
            case EXP_NOT: {
                this.checkAliasesAreDefined(expr.getLeft());
                return;
            }
            case EXP_ATOM: {
                if (expr.getAtom().isAlias() && !this.aliases.contains(expr.getAtom().getAliasName())) {
                    throw new HOAConsumerException("Alias @" + expr.getAtom().getAliasName() + " is not defined");
                }
                return;
            }
        }
        throw new UnsupportedOperationException("Unknown operator in label expression: " + expr);
    }

    private void gatherLabels(BooleanExpression<AtomLabel> expr, BitSet result) {
        switch (expr.getType()) {
            case EXP_TRUE: 
            case EXP_FALSE: {
                return;
            }
            case EXP_AND: 
            case EXP_OR: {
                this.gatherLabels(expr.getLeft(), result);
                this.gatherLabels(expr.getRight(), result);
                return;
            }
            case EXP_NOT: {
                this.gatherLabels(expr.getLeft(), result);
                return;
            }
            case EXP_ATOM: {
                if (!expr.getAtom().isAlias()) {
                    result.set(expr.getAtom().getAPIndex());
                }
                return;
            }
        }
        throw new UnsupportedOperationException("Unknown operator in label expression: " + expr);
    }

    private void checkLabelExpression(BooleanExpression<AtomLabel> expr) throws HOAConsumerException {
        switch (expr.getType()) {
            case EXP_TRUE: 
            case EXP_FALSE: {
                return;
            }
            case EXP_AND: 
            case EXP_OR: {
                this.checkLabelExpression(expr.getLeft());
                this.checkLabelExpression(expr.getRight());
                return;
            }
            case EXP_NOT: {
                this.checkLabelExpression(expr.getLeft());
                return;
            }
            case EXP_ATOM: {
                if (expr.getAtom().isAlias()) {
                    if (!this.aliases.contains(expr.getAtom().getAliasName())) {
                        throw new HOAConsumerException("Alias @" + expr.getAtom().getAliasName() + " is not defined");
                    }
                } else {
                    assert (this.numberOfAPs != null);
                    int apIndex = expr.getAtom().getAPIndex();
                    if (apIndex >= this.numberOfAPs) {
                        if (this.numberOfAPs == 0) {
                            throw new HOAConsumerException("AP index " + apIndex + " in expression is out of range (no APs): " + expr);
                        }
                        throw new HOAConsumerException("AP index " + apIndex + " in expression is out of range (from 0 to " + (this.numberOfAPs - 1) + "): " + expr);
                    }
                }
                return;
            }
        }
        throw new UnsupportedOperationException("Unknown operator in label expression: " + expr);
    }

    private void checkAccName() throws HOAConsumerException {
        AcceptanceRepositoryStandard repository = new AcceptanceRepositoryStandard();
        try {
            BooleanExpression<AtomAcceptance> canonical = repository.getCanonicalAcceptanceExpression(this.accName, this.accExtraInfo);
            if (canonical == null) {
                return;
            }
            assert (this.acceptance != null);
            if (!BooleanExpression.areSyntacticallyEqual(this.acceptance, canonical)) {
                throw new HOAConsumerException("The acceptance given by the Acceptance and by the acc-name headers do not match syntactically:\nFrom Acceptance-header: " + this.acceptance + "\nCanonical expression for acc-name-header: " + canonical);
            }
        }
        catch (IllegalArgumentException e) {
            throw new HOAConsumerException(e.getMessage());
        }
    }
}

