/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;

public class StoredHeader {
    private Integer numberOfStates = null;
    private List<List<Integer>> startStates = new ArrayList<List<Integer>>();
    private List<String> aps = new ArrayList<String>();
    private int numberOfAcceptanceSets;
    private BooleanExpression<AtomAcceptance> accExpr;
    private List<NameAndExtra<List<Object>>> accNames = new ArrayList<NameAndExtra<List<Object>>>();
    private List<NameAndExtra<List<Object>>> miscHeaders = new ArrayList<NameAndExtra<List<Object>>>();
    private String name;
    private String tool;
    private String toolVersion;
    private SortedSet<String> properties = new TreeSet<String>();
    private List<NameAndExtra<BooleanExpression<AtomLabel>>> aliases = new ArrayList<NameAndExtra<BooleanExpression<AtomLabel>>>();
    private HashSet<String> aliasNames = new HashSet();

    public StoredHeader clone() {
        StoredHeader result = new StoredHeader();
        result.numberOfStates = this.numberOfStates;
        for (List<Integer> list : this.startStates) {
            result.addStartStates(new ArrayList<Integer>(list));
        }
        result.setAPs(new ArrayList<String>(this.aps));
        result.setAcceptanceCondition(this.numberOfAcceptanceSets, (BooleanExpression<AtomAcceptance>)this.accExpr.clone());
        for (NameAndExtra nameAndExtra : this.accNames) {
            result.provideAcceptanceName(nameAndExtra.name, (List)nameAndExtra.extra);
        }
        for (NameAndExtra nameAndExtra : this.miscHeaders) {
            result.provideAcceptanceName(nameAndExtra.name, (List)nameAndExtra.extra);
        }
        for (NameAndExtra nameAndExtra : this.aliases) {
            result.addAlias(nameAndExtra.name, (BooleanExpression<AtomLabel>)((BooleanExpression)nameAndExtra.extra).clone());
        }
        if (this.name != null) {
            result.setTool(this.tool, this.toolVersion);
        }
        if (this.name != null) {
            result.setName(this.name);
        }
        result.addProperties(this.properties);
        return result;
    }

    public void setNumberOfStates(Integer numberOfStates) {
        this.numberOfStates = numberOfStates;
    }

    public Integer getNumberOfStates() {
        return this.numberOfStates;
    }

    public void addStartStates(List<Integer> stateConjunction) {
        this.startStates.add(stateConjunction);
    }

    public List<List<Integer>> getStartStates() {
        return this.startStates;
    }

    public void addAlias(String name, BooleanExpression<AtomLabel> labelExpr) {
        if (this.hasAlias(name)) {
            throw new UnsupportedOperationException("Can not store alias " + name + " multiple times");
        }
        this.aliases.add(new NameAndExtra<BooleanExpression<AtomLabel>>(name, labelExpr));
        this.aliasNames.add(name);
    }

    public List<NameAndExtra<BooleanExpression<AtomLabel>>> getAliases() {
        return this.aliases;
    }

    public boolean hasAlias(String name) {
        return this.aliasNames.contains(name);
    }

    public void setAPs(List<String> aps) {
        this.aps = aps;
    }

    public List<String> getAPs() {
        return this.aps;
    }

    public void setAcceptanceCondition(int numberOfSets, BooleanExpression<AtomAcceptance> accExpr) {
        this.numberOfAcceptanceSets = numberOfSets;
        this.accExpr = accExpr;
    }

    public int getNumberOfAcceptanceSets() {
        return this.numberOfAcceptanceSets;
    }

    public BooleanExpression<AtomAcceptance> getAcceptanceCondition() {
        return this.accExpr;
    }

    public void provideAcceptanceName(String name, List<Object> extraInfo) {
        this.accNames.add(new NameAndExtra<List<Object>>(name, extraInfo));
    }

    public void removeAcceptanceNames() {
        this.accNames.clear();
    }

    public List<NameAndExtra<List<Object>>> getAcceptanceNames() {
        return this.accNames;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setTool(String name, String version) {
        this.tool = name;
        this.toolVersion = version;
    }

    public String getTool() {
        return this.tool;
    }

    public String getToolVersion() {
        return this.toolVersion;
    }

    public void addProperty(String property) {
        this.properties.add(property);
    }

    public void addProperties(Collection<String> properties) {
        this.properties.addAll(properties);
    }

    public Set<String> getProperties() {
        return this.properties;
    }

    public void addMiscHeader(String name, List<Object> content) {
        this.miscHeaders.add(new NameAndExtra<List<Object>>(name, content));
    }

    public List<NameAndExtra<List<Object>>> getMiscHeaders() {
        return this.miscHeaders;
    }

    public void feedToConsumer(HOAConsumer c) throws HOAConsumerException {
        if (!this.properties.isEmpty()) {
            c.addProperties(new ArrayList<String>(this.properties));
        }
        if (this.getNumberOfStates() != null) {
            c.setNumberOfStates(this.getNumberOfStates());
        }
        for (List<Integer> list : this.getStartStates()) {
            c.addStartStates(list);
        }
        c.setAPs(this.getAPs());
        for (NameAndExtra nameAndExtra : this.getAliases()) {
            c.addAlias(nameAndExtra.name, (BooleanExpression)nameAndExtra.extra);
        }
        if (this.getAcceptanceCondition() != null) {
            c.setAcceptanceCondition(this.getNumberOfAcceptanceSets(), this.getAcceptanceCondition());
        }
        for (NameAndExtra nameAndExtra : this.getAcceptanceNames()) {
            c.provideAcceptanceName(nameAndExtra.name, (List)nameAndExtra.extra);
        }
        if (this.getName() != null) {
            c.setName(this.getName());
        }
        if (this.getTool() != null) {
            c.setTool(this.getTool(), this.getToolVersion());
        }
    }

    public static class NameAndExtra<T> {
        public String name;
        public T extra;

        NameAndExtra(String name, T extraInfo) {
            this.name = name;
            this.extra = extraInfo;
        }
    }
}

