/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.AutomatonUtil;
import owl.automaton.ImmutableViewSettings;
import owl.automaton.ImplicitCachedStatesAutomaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.NoneAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.edge.LabelledEdge;
import owl.automaton.edge.LabelledEdges;
import owl.collections.Collections3;
import owl.collections.ValuationSet;
import owl.factories.ValuationSetFactory;

public final class Views {
    private Views() {
    }

    public static <S> Automaton<S, OmegaAcceptance> complement(Automaton<S, ?> automaton) {
        return Views.complement(automaton, null);
    }

    public static <S> Automaton<S, OmegaAcceptance> complement(Automaton<S, ?> automaton, @Nullable S trapState) {
        Automaton<S, ?> completeAutomaton = trapState == null ? automaton : Views.complete(automaton, trapState);
        Preconditions.checkArgument((boolean)completeAutomaton.is(Automaton.Property.COMPLETE), (Object)"Automaton is not complete.");
        Preconditions.checkArgument((!completeAutomaton.initialStates().isEmpty() ? 1 : 0) != 0, (Object)"Automaton is empty.");
        Object acceptance = completeAutomaton.acceptance();
        if (acceptance instanceof BuchiAcceptance) {
            return Views.createView(completeAutomaton, Views.builder().acceptance(CoBuchiAcceptance.INSTANCE).build());
        }
        if (acceptance instanceof CoBuchiAcceptance) {
            return Views.createView(completeAutomaton, Views.builder().acceptance(BuchiAcceptance.INSTANCE).build());
        }
        if (acceptance instanceof ParityAcceptance) {
            ParityAcceptance parityAcceptance = (ParityAcceptance)automaton.acceptance();
            return Views.createView(completeAutomaton, Views.builder().acceptance(parityAcceptance.complement()).build());
        }
        throw new UnsupportedOperationException();
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> complete(Automaton<S, A> automaton, S trapState) {
        A acceptance = automaton.acceptance();
        return new Complete<S, A, A>(automaton, Edge.of(trapState, ((OmegaAcceptance)acceptance).rejectingSet()), acceptance);
    }

    public static <S> Automaton<S, CoBuchiAcceptance> completeAllAcceptance(Automaton<S, AllAcceptance> automaton, S trapState) {
        return new Complete<S, AllAcceptance, CoBuchiAcceptance>(automaton, Edge.of(trapState, 0), CoBuchiAcceptance.INSTANCE);
    }

    public static <S, A extends OmegaAcceptance> Automaton<Set<S>, A> createPowerSetAutomaton(Automaton<S, ?> automaton, A acceptance, boolean dropEmptySet) {
        return AutomatonFactory.create(automaton.factory(), automaton.initialStates(), acceptance, (states, valuation) -> {
            Set successors = states.stream().flatMap(x -> automaton.successors((Object)x, (BitSet)valuation).stream()).collect(Collectors.toUnmodifiableSet());
            return dropEmptySet && successors.isEmpty() ? null : Edge.of(successors);
        });
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> filter(Automaton<S, A> automaton, Set<S> states) {
        return Views.createView(automaton, Views.builder().stateFilter(states::contains).build());
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> filter(Automaton<S, A> automaton, Set<S> states, Predicate<Edge<S>> edgeFilter) {
        return Views.createView(automaton, Views.builder().edgeFilter(edgeFilter).stateFilter(states::contains).build());
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> remap(Automaton<S, A> automaton, IntUnaryOperator remappingOperator) {
        return Views.createView(automaton, Views.builder().edgeRewriter(edge -> edge.withAcceptance(remappingOperator)).build());
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> replaceInitialState(Automaton<S, A> automaton, Set<S> initialStates) {
        return Views.createView(automaton, Views.builder().initialStates(initialStates).build());
    }

    static <S, A extends OmegaAcceptance> Automaton<S, A> createView(Automaton<S, ?> automaton, ViewSettings<S, A> settings) {
        return new AutomatonView(automaton, settings);
    }

    static <S, A extends OmegaAcceptance> ImmutableViewSettings.Builder<S, A> builder() {
        return ImmutableViewSettings.builder();
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> viewAs(Automaton<S, ?> automaton, Class<A> acceptanceClazz) {
        if (acceptanceClazz.isInstance(automaton.acceptance())) {
            return AutomatonUtil.cast(automaton, acceptanceClazz);
        }
        if (ParityAcceptance.class.equals(acceptanceClazz)) {
            Preconditions.checkArgument((boolean)(automaton.acceptance() instanceof BuchiAcceptance));
            ImmutableViewSettings<S, ParityAcceptance> remapping = Views.builder().acceptance(new ParityAcceptance(2, ParityAcceptance.Parity.MIN_EVEN)).edgeRewriter(edge -> edge.inSet(0) ? edge : Edge.of(edge.successor(), 1)).build();
            return AutomatonUtil.cast(Views.createView(automaton, remapping), acceptanceClazz);
        }
        if (RabinAcceptance.class.equals(acceptanceClazz)) {
            Preconditions.checkArgument((boolean)(automaton.acceptance() instanceof BuchiAcceptance));
            ImmutableViewSettings<S, RabinAcceptance> remapping = Views.builder().acceptance(RabinAcceptance.of(GeneralizedRabinAcceptance.RabinPair.of(0))).edgeRewriter(edge -> edge.withAcceptance(x -> x + 1)).build();
            return AutomatonUtil.cast(Views.createView(automaton, remapping), acceptanceClazz);
        }
        if (GeneralizedRabinAcceptance.class.equals(acceptanceClazz)) {
            Preconditions.checkArgument((boolean)(automaton.acceptance() instanceof GeneralizedBuchiAcceptance));
            int sets = ((OmegaAcceptance)automaton.acceptance()).acceptanceSets();
            ImmutableViewSettings<S, GeneralizedRabinAcceptance> remapping = Views.builder().acceptance(GeneralizedRabinAcceptance.of(GeneralizedRabinAcceptance.RabinPair.ofGeneralized(0, sets))).edgeRewriter(edge -> edge.withAcceptance(x -> x + 1)).build();
            return AutomatonUtil.cast(Views.createView(automaton, remapping), acceptanceClazz);
        }
        if (BuchiAcceptance.class.equals(acceptanceClazz) || GeneralizedBuchiAcceptance.class.equals(acceptanceClazz)) {
            Preconditions.checkArgument((boolean)(automaton.acceptance() instanceof AllAcceptance));
            ImmutableViewSettings<S, BuchiAcceptance> remapping = Views.builder().acceptance(BuchiAcceptance.INSTANCE).edgeRewriter(edge -> edge.withAcceptance(0)).build();
            return AutomatonUtil.cast(Views.createView(automaton, remapping), acceptanceClazz);
        }
        throw new UnsupportedOperationException();
    }

    public static <S> Automaton<S, NoneAcceptance> viewAsLts(Automaton<S, ?> automaton) {
        ImmutableViewSettings<S, NoneAcceptance> remapping = Views.builder().acceptance(NoneAcceptance.INSTANCE).edgeRewriter(edge -> Edge.of(edge.successor())).build();
        return Views.createView(automaton, remapping);
    }

    public static class AutomatonView<S, A extends OmegaAcceptance>
    extends ImplicitCachedStatesAutomaton<S, A> {
        private final Automaton<S, ?> backingAutomaton;
        private final ViewSettings<S, A> settings;

        private AutomatonView(Automaton<S, ?> automaton, ViewSettings<S, A> settings) {
            super(automaton.factory(), AutomatonView.initialStates(automaton, settings), AutomatonView.acceptance(automaton, settings));
            this.backingAutomaton = automaton;
            this.settings = settings;
        }

        private static <S, A extends OmegaAcceptance> A acceptance(Automaton<S, ?> automaton, ViewSettings<S, A> settings) {
            A acceptance = settings.acceptance();
            return (A)(acceptance == null ? automaton.acceptance() : acceptance);
        }

        private static <S> Set<S> initialStates(Automaton<S, ?> automaton, ViewSettings<S, ?> settings) {
            Set<S> initialStates = settings.initialStates();
            if (initialStates != null) {
                return initialStates;
            }
            Predicate<S> stateFilter = settings.stateFilter();
            if (stateFilter == null) {
                return automaton.initialStates();
            }
            return Sets.filter(automaton.initialStates(), stateFilter::test);
        }

        private boolean stateFilter(S state) {
            Predicate<S> filter = this.settings.stateFilter();
            return filter == null || filter.test(state);
        }

        private boolean edgeFilter(Edge<S> edge) {
            Predicate<Edge<S>> filter = this.settings.edgeFilter();
            return (filter == null || filter.test(edge)) && this.stateFilter(edge.successor());
        }

        @Override
        public boolean prefersLabelled() {
            return this.backingAutomaton.prefersLabelled();
        }

        @Override
        public Collection<Edge<S>> edges(S state, BitSet valuation) {
            Preconditions.checkArgument((boolean)this.stateFilter(state));
            Collection filteredEdges = Collections2.filter(this.backingAutomaton.edges(state, valuation), this::edgeFilter);
            Function<Edge<S>, Edge<S>> edgeRewriter = this.settings.edgeRewriter();
            return edgeRewriter == null ? filteredEdges : Collections2.transform((Collection)filteredEdges, edgeRewriter::apply);
        }

        @Override
        public Collection<Edge<S>> edges(S state) {
            Preconditions.checkArgument((boolean)this.stateFilter(state));
            Collection filteredEdges = Collections2.filter(this.backingAutomaton.edges(state), this::edgeFilter);
            Function<Edge<S>, Edge<S>> edgeRewriter = this.settings.edgeRewriter();
            return edgeRewriter == null ? filteredEdges : Collections2.transform((Collection)filteredEdges, edgeRewriter::apply);
        }

        @Override
        public Collection<LabelledEdge<S>> labelledEdges(S state) {
            Preconditions.checkArgument((boolean)this.stateFilter(state));
            Collection filteredEdges = Collections2.filter(this.backingAutomaton.labelledEdges(state), x -> this.edgeFilter(x.edge));
            Function edgeRewriter = this.settings.edgeRewriter();
            return edgeRewriter == null ? filteredEdges : Collections2.transform((Collection)filteredEdges, labelledEdge -> labelledEdge.map(edgeRewriter));
        }

        @Override
        public Set<S> successors(S state) {
            return this.edges(state).stream().map(Edge::successor).collect(Collectors.toSet());
        }

        @Override
        public boolean is(Automaton.Property property) {
            Boolean value = this.settings.properties().get((Object)property);
            return value == null ? super.is(property) : value.booleanValue();
        }
    }

    @Value.Immutable
    static abstract class ViewSettings<S, A extends OmegaAcceptance> {
        ViewSettings() {
        }

        @Nullable
        abstract A acceptance();

        @Nullable
        abstract Set<S> initialStates();

        @Nullable
        abstract Predicate<S> stateFilter();

        @Nullable
        abstract Predicate<Edge<S>> edgeFilter();

        @Nullable
        abstract Function<Edge<S>, Edge<S>> edgeRewriter();

        @Value.Default
        Map<Automaton.Property, Boolean> properties() {
            return Map.of();
        }
    }

    static class Complete<S, A extends OmegaAcceptance, B extends OmegaAcceptance>
    implements Automaton<S, B> {
        private final Edge<S> sinkEdge;
        private final Automaton<S, A> automaton;
        private final S sink;
        private final B acceptance;
        @Nullable
        private Map<S, ValuationSet> incompleteStates;

        Complete(Automaton<S, A> automaton, Edge<S> sinkEdge, B acceptance) {
            this.automaton = automaton;
            this.sink = sinkEdge.successor();
            this.sinkEdge = sinkEdge;
            this.acceptance = acceptance;
        }

        @Override
        public B acceptance() {
            return this.acceptance;
        }

        @Override
        public ValuationSetFactory factory() {
            return this.automaton.factory();
        }

        @Override
        public boolean prefersLabelled() {
            return this.automaton.prefersLabelled();
        }

        @Override
        public Set<S> initialStates() {
            return this.automaton.initialStates();
        }

        @Override
        public Set<S> states() {
            if (this.incompleteStates == null) {
                this.incompleteStates = AutomatonUtil.getIncompleteStates(this.automaton);
            }
            if (this.incompleteStates.isEmpty()) {
                return this.automaton.states();
            }
            return Sets.union(this.automaton.states(), Set.of(this.sink));
        }

        @Override
        public Set<S> successors(S state) {
            if (this.sink.equals(state)) {
                return Set.of(this.sink);
            }
            if (this.incompleteStates != null && this.incompleteStates.containsKey(state)) {
                return Sets.union(this.automaton.states(), Set.of(this.sink));
            }
            return new HashSet<S>(LabelledEdges.successors(this.labelledEdges(state)));
        }

        @Override
        public Collection<Edge<S>> edges(S state, BitSet valuation) {
            if (this.sink.equals(state)) {
                return List.of(this.sinkEdge);
            }
            Collection<Edge<S>> edges = this.automaton.edges(state, valuation);
            return edges.isEmpty() ? List.of(this.sinkEdge) : edges;
        }

        @Override
        public Collection<Edge<S>> edges(S state) {
            if (this.sink.equals(state)) {
                return List.of(this.sinkEdge);
            }
            if (this.incompleteStates != null && this.incompleteStates.containsKey(state)) {
                return Collections3.append(this.automaton.edges(state), this.sinkEdge);
            }
            return LabelledEdges.edges(this.labelledEdges(state));
        }

        @Override
        public Collection<LabelledEdge<S>> labelledEdges(S state) {
            ValuationSetFactory factory = this.automaton.factory();
            if (this.sink.equals(state)) {
                return List.of(LabelledEdge.of(this.sinkEdge, factory.universe()));
            }
            if (this.incompleteStates != null && this.incompleteStates.containsKey(state)) {
                return Collections3.append(this.automaton.labelledEdges(state), LabelledEdge.of(this.sinkEdge, this.incompleteStates.get(state)));
            }
            ArrayList<LabelledEdge<S>> edges = new ArrayList<LabelledEdge<S>>(this.automaton.labelledEdges(state));
            ValuationSet complement = factory.union(LabelledEdges.valuations(edges)).complement();
            if (!complement.isEmpty()) {
                edges.add(LabelledEdge.of(this.sinkEdge, complement));
            }
            return edges;
        }

        @Override
        public boolean is(Automaton.Property property) {
            return property == Automaton.Property.COMPLETE || this.automaton.is(property);
        }
    }
}

