/*
 * Decompiled with CFR 0.152.
 */
package owl.factories;

import java.util.ArrayDeque;
import java.util.Deque;
import owl.ltl.BinaryModalOperator;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.FrequencyG;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.PropositionalFormula;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.UnaryModalOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.IntVisitor;

public final class PropositionVisitor
implements IntVisitor {
    private final Deque<Formula> mapping = new ArrayDeque<Formula>();

    private PropositionVisitor() {
    }

    public static Deque<Formula> extractPropositions(Formula formula) {
        PropositionVisitor visitor = new PropositionVisitor();
        formula.accept(visitor);
        return visitor.mapping;
    }

    @Override
    public int visit(BooleanConstant booleanConstant) {
        return 0;
    }

    @Override
    public int visit(Conjunction conjunction) {
        return this.visit((PropositionalFormula)conjunction);
    }

    @Override
    public int visit(Disjunction disjunction) {
        return this.visit((PropositionalFormula)disjunction);
    }

    @Override
    public int visit(FOperator fOperator) {
        return this.visit((UnaryModalOperator)fOperator);
    }

    @Override
    public int visit(FrequencyG freq) {
        return this.visit((UnaryModalOperator)freq);
    }

    @Override
    public int visit(GOperator gOperator) {
        return this.visit((UnaryModalOperator)gOperator);
    }

    @Override
    public int visit(Literal literal) {
        this.mapping.add(literal);
        return 0;
    }

    @Override
    public int visit(MOperator mOperator) {
        return this.visit((BinaryModalOperator)mOperator);
    }

    @Override
    public int visit(ROperator rOperator) {
        return this.visit((BinaryModalOperator)rOperator);
    }

    @Override
    public int visit(UOperator uOperator) {
        return this.visit((BinaryModalOperator)uOperator);
    }

    @Override
    public int visit(WOperator wOperator) {
        return this.visit((BinaryModalOperator)wOperator);
    }

    @Override
    public int visit(XOperator xOperator) {
        return this.visit((UnaryModalOperator)xOperator);
    }

    private int visit(BinaryModalOperator operator) {
        operator.left.accept(this);
        operator.right.accept(this);
        this.mapping.add(operator);
        return 0;
    }

    private int visit(PropositionalFormula formula) {
        formula.children.forEach(c -> c.accept(this));
        return 0;
    }

    private int visit(UnaryModalOperator operator) {
        operator.operand.accept(this);
        this.mapping.add(operator);
        return 0;
    }
}

