/*
 * Decompiled with CFR 0.152.
 */
package owl.factories.jbdd;

import de.tum.in.jbdd.Bdd;
import de.tum.in.jbdd.BddConfiguration;
import de.tum.in.jbdd.BddFactory;
import de.tum.in.jbdd.ImmutableBddConfiguration;
import java.util.List;
import owl.factories.EquivalenceClassFactory;
import owl.factories.Factories;
import owl.factories.FactorySupplier;
import owl.factories.ValuationSetFactory;
import owl.factories.jbdd.EquivalenceFactory;
import owl.factories.jbdd.ValuationFactory;

public final class JBddSupplier
implements FactorySupplier {
    private static final JBddSupplier PLAIN = new JBddSupplier(false, false);
    private static final JBddSupplier ANNOTATED = new JBddSupplier(true, false);
    private final boolean keepRepresentativesDefault;
    private final boolean sync;

    private JBddSupplier(boolean keepRepresentativesDefault, boolean sync) {
        this.keepRepresentativesDefault = keepRepresentativesDefault;
        this.sync = sync;
    }

    public static FactorySupplier async(boolean keepRepresentativesDefault) {
        return keepRepresentativesDefault ? ANNOTATED : PLAIN;
    }

    private Bdd create(int size) {
        ImmutableBddConfiguration configuration = ImmutableBddConfiguration.builder().logStatisticsOnShutdown(false).build();
        return this.sync ? BddFactory.buildSynchronizedBdd((int)size, (BddConfiguration)configuration) : BddFactory.buildBdd((int)size, (BddConfiguration)configuration);
    }

    @Override
    public EquivalenceClassFactory getEquivalenceClassFactory(List<String> alphabet) {
        return this.getEquivalenceClassFactory(alphabet, this.keepRepresentativesDefault);
    }

    @Override
    public EquivalenceClassFactory getEquivalenceClassFactory(List<String> alphabet, boolean keepRepresentatives) {
        Bdd eqFactoryBdd = this.create(1024 * (alphabet.size() + 1));
        return new EquivalenceFactory(eqFactoryBdd, alphabet, keepRepresentatives);
    }

    @Override
    public Factories getFactories(List<String> alphabet) {
        return new Factories(this.getEquivalenceClassFactory(alphabet, this.keepRepresentativesDefault), this.getValuationSetFactory(alphabet));
    }

    @Override
    public ValuationSetFactory getValuationSetFactory(List<String> alphabet) {
        int alphabetSize = alphabet.size();
        Bdd vsFactoryBdd = this.create(1024 * alphabetSize * alphabetSize + 256);
        return new ValuationFactory(vsFactoryBdd, alphabet);
    }
}

