/*
 * Decompiled with CFR 0.152.
 */
package owl.run.parser;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import owl.run.parser.PartialModuleConfiguration;
import owl.run.parser.Wrapper;

@ParametersAreNonnullByDefault
@Generated(from="PartialModuleConfiguration", generator="Immutables")
@NotThreadSafe
final class PartialModuleConfigurationBuilder {
    private static final long INIT_BIT_INPUT = 1L;
    private static final long INIT_BIT_OUTPUT = 2L;
    private static final long INIT_BIT_NAME = 4L;
    private long initBits = 7L;
    @Nullable
    private Wrapper input;
    private ImmutableList.Builder<Wrapper> transformers = ImmutableList.builder();
    @Nullable
    private Wrapper output;
    @Nullable
    private String name;

    PartialModuleConfigurationBuilder() {
    }

    @CanIgnoreReturnValue
    public final PartialModuleConfigurationBuilder from(PartialModuleConfiguration instance) {
        Objects.requireNonNull(instance, "instance");
        this.input(instance.input());
        this.addAllTransformers(instance.transformers());
        this.output(instance.output());
        this.name(instance.name());
        return this;
    }

    @CanIgnoreReturnValue
    public final PartialModuleConfigurationBuilder input(Wrapper input) {
        this.input = Objects.requireNonNull(input, "input");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    @CanIgnoreReturnValue
    public final PartialModuleConfigurationBuilder addTransformers(Wrapper element) {
        this.transformers.add((Object)element);
        return this;
    }

    @CanIgnoreReturnValue
    public final PartialModuleConfigurationBuilder addTransformers(Wrapper ... elements) {
        this.transformers.add((Object[])elements);
        return this;
    }

    @CanIgnoreReturnValue
    public final PartialModuleConfigurationBuilder transformers(Iterable<? extends Wrapper> elements) {
        this.transformers = ImmutableList.builder();
        return this.addAllTransformers(elements);
    }

    @CanIgnoreReturnValue
    public final PartialModuleConfigurationBuilder addAllTransformers(Iterable<? extends Wrapper> elements) {
        this.transformers.addAll(elements);
        return this;
    }

    @CanIgnoreReturnValue
    public final PartialModuleConfigurationBuilder output(Wrapper output) {
        this.output = Objects.requireNonNull(output, "output");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    @CanIgnoreReturnValue
    public final PartialModuleConfigurationBuilder name(String name) {
        this.name = Objects.requireNonNull(name, "name");
        this.initBits &= 0xFFFFFFFFFFFFFFFBL;
        return this;
    }

    public PartialModuleConfiguration build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutablePartialModuleConfiguration(this);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("input");
        }
        if ((this.initBits & 2L) != 0L) {
            attributes.add("output");
        }
        if ((this.initBits & 4L) != 0L) {
            attributes.add("name");
        }
        return "Cannot build PartialModuleConfiguration, some of required attributes are not set " + attributes;
    }

    @CheckReturnValue
    @Immutable
    private static final class ImmutablePartialModuleConfiguration
    extends PartialModuleConfiguration {
        private final Wrapper input;
        private final ImmutableList<Wrapper> transformers;
        private final Wrapper output;
        private final String name;

        private ImmutablePartialModuleConfiguration(PartialModuleConfigurationBuilder builder) {
            this.input = builder.input;
            this.transformers = builder.transformers.build();
            this.output = builder.output;
            this.name = builder.name;
        }

        @Override
        Wrapper input() {
            return this.input;
        }

        ImmutableList<Wrapper> transformers() {
            return this.transformers;
        }

        @Override
        Wrapper output() {
            return this.output;
        }

        @Override
        String name() {
            return this.name;
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutablePartialModuleConfiguration && this.equalTo((ImmutablePartialModuleConfiguration)another);
        }

        private boolean equalTo(ImmutablePartialModuleConfiguration another) {
            return this.input.equals(another.input) && this.transformers.equals(another.transformers) && this.output.equals(another.output) && this.name.equals(another.name);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.input.hashCode();
            h += (h << 5) + this.transformers.hashCode();
            h += (h << 5) + this.output.hashCode();
            h += (h << 5) + this.name.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"PartialModuleConfiguration").omitNullValues().add("input", (Object)this.input).add("transformers", this.transformers).add("output", (Object)this.output).add("name", (Object)this.name).toString();
        }
    }
}

