/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.dra2dpa;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.Views;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.NoneAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.automaton.edge.LabelledEdge;
import owl.automaton.output.HoaPrinter;
import owl.collections.ValuationSet;
import owl.factories.ValuationSetFactory;
import owl.run.PipelineException;
import owl.run.modules.ImmutableTransformerParser;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.OwlModuleParser;
import owl.run.modules.Transformers;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.dra2dpa.IARState;
import owl.translations.dra2dpa.SccIARBuilder;

public final class IARBuilder<R> {
    public static final OwlModuleParser.TransformerParser CLI = ImmutableTransformerParser.builder().key("dra2dpa").description("Converts a Rabin automaton into a parity automaton").parser(settings -> Transformers.RABIN_TO_PARITY).build();
    private static final Logger logger = Logger.getLogger(IARBuilder.class.getName());
    private final Automaton<R, RabinAcceptance> rabinAutomaton;
    private final MutableAutomaton<IARState<R>, ParityAcceptance> resultAutomaton;
    private final ValuationSetFactory vsFactory;

    public IARBuilder(Automaton<R, RabinAcceptance> rabinAutomaton) {
        this.rabinAutomaton = rabinAutomaton;
        this.vsFactory = rabinAutomaton.factory();
        ParityAcceptance acceptance = new ParityAcceptance(0, ParityAcceptance.Parity.MIN_ODD);
        this.resultAutomaton = MutableAutomatonFactory.create(acceptance, this.vsFactory);
    }

    public static void main(String ... args) {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.builder("dra2dpa").reader(InputReaders.HoaReader.DEFAULT).addTransformer(CLI).addTransformer(Transformers.MINIMIZER).writer(OutputWriters.ToHoa.DEFAULT).build());
    }

    public Automaton<IARState<R>, ParityAcceptance> build() {
        logger.log(Level.FINE, "Building IAR automaton with SCC decomposition");
        logger.log(Level.FINEST, () -> "Input automaton is\n" + HoaPrinter.toString(this.rabinAutomaton));
        Set<GeneralizedRabinAcceptance.RabinPair> rabinPairs = Set.copyOf(this.rabinAutomaton.acceptance().pairs());
        if (rabinPairs.isEmpty()) {
            IARState<R> state2 = IARState.trivial(this.rabinAutomaton.initialStates().iterator().next());
            return AutomatonFactory.singleton(this.rabinAutomaton.factory(), state2, new ParityAcceptance(1, ParityAcceptance.Parity.MIN_ODD), Collections.singleton(0));
        }
        List<Set<R>> rabinSccs = SccDecomposition.computeSccs(this.rabinAutomaton);
        logger.log(Level.FINER, "Found {0} SCCs", rabinSccs.size());
        ExecutorCompletionService<SccProcessingResult> completionService = new ExecutorCompletionService<SccProcessingResult>(MoreExecutors.directExecutor());
        for (Set<R> rabinScc : rabinSccs) {
            completionService.submit(() -> this.processScc(rabinScc, rabinPairs));
        }
        logger.log(Level.FINE, "Waiting for completion");
        ImmutableMultimap.Builder interSccConnectionsBuilder = ImmutableMultimap.builder();
        int completedSccs = 0;
        int maximalSubAutomatonPriority = 0;
        while (completedSccs < rabinSccs.size()) {
            SccProcessingResult result;
            Future currentResultFuture;
            try {
                logger.log(Level.FINE, "Waiting for completion");
                currentResultFuture = completionService.take();
            }
            catch (InterruptedException e) {
                logger.log(Level.FINE, "Interrupted", e);
                continue;
            }
            assert (currentResultFuture.isDone());
            try {
                result = (SccProcessingResult)Uninterruptibles.getUninterruptibly(currentResultFuture);
            }
            catch (ExecutionException e) {
                throw PipelineException.propagate(e);
            }
            Automaton subAutomaton = result.subAutomaton;
            Object subAutomatonAcceptance = subAutomaton.acceptance();
            if (subAutomatonAcceptance instanceof ParityAcceptance) {
                maximalSubAutomatonPriority = Math.max(maximalSubAutomatonPriority, ((OmegaAcceptance)subAutomatonAcceptance).acceptanceSets() - 1);
            }
            interSccConnectionsBuilder.putAll(result.interSccConnections);
            Set iarStates = subAutomaton.states();
            iarStates.forEach(this.resultAutomaton::addInitialState);
            iarStates.forEach(state -> subAutomaton.forEachLabelledEdge(state, (edge, valuations) -> this.resultAutomaton.addEdge((IARState<R>)state, (ValuationSet)valuations, (Edge<IARState<R>>)edge)));
            ++completedSccs;
        }
        ImmutableMultimap interSccConnections = interSccConnectionsBuilder.build();
        HashMap rabinToIarStateMap = Maps.newHashMapWithExpectedSize((int)this.rabinAutomaton.size());
        this.resultAutomaton.states().forEach(state -> rabinToIarStateMap.put(state.state(), state));
        assert (Objects.equals(rabinToIarStateMap.keySet(), this.rabinAutomaton.states()));
        logger.log(Level.FINE, "Connecting the SCCs");
        this.resultAutomaton.states().forEach(iarState -> interSccConnections.get(iarState.state()).forEach(labelledEdge -> {
            IARState successor = (IARState)rabinToIarStateMap.get(labelledEdge.edge.successor());
            Edge<IARState> iarEdge = Edge.of(successor, 0);
            this.resultAutomaton.addEdge((IARState<R>)iarState, labelledEdge.valuations, (Edge<IARState<R>>)iarEdge);
        }));
        this.resultAutomaton.initialStates(this.rabinAutomaton.initialStates().stream().map(rabinToIarStateMap::get).collect(Collectors.toSet()));
        this.resultAutomaton.trim();
        int sets = maximalSubAutomatonPriority + 1;
        this.resultAutomaton.updateAcceptance(x -> x.withAcceptanceSets(sets));
        assert (rabinSccs.size() == SccDecomposition.computeSccs(this.resultAutomaton).size());
        return this.resultAutomaton;
    }

    private SccProcessingResult<R> getTrivialSccResult(Set<R> simpleScc, Multimap<R, LabelledEdge<R>> interSccConnections) {
        MutableAutomaton resultTransitionSystem = MutableAutomatonFactory.create(new ParityAcceptance(1, ParityAcceptance.Parity.MIN_ODD), this.vsFactory);
        for (R state : simpleScc) {
            IARState iarState = IARState.trivial(state);
            resultTransitionSystem.addInitialState(iarState);
            this.rabinAutomaton.forEachLabelledEdge(state, (edge, valuations) -> {
                if (simpleScc.contains(edge.successor())) {
                    Edge iarEdge = Edge.of(IARState.trivial(edge.successor()), 0);
                    resultTransitionSystem.addEdge(iarState, (ValuationSet)valuations, (Edge)iarEdge);
                }
            });
        }
        return new SccProcessingResult<R>(interSccConnections, resultTransitionSystem);
    }

    private SccProcessingResult<R> processScc(Set<R> scc, Set<GeneralizedRabinAcceptance.RabinPair> rabinPairs) {
        assert (!rabinPairs.isEmpty());
        HashSet<GeneralizedRabinAcceptance.RabinPair> remainingPairsToCheck = new HashSet<GeneralizedRabinAcceptance.RabinPair>(rabinPairs);
        ImmutableMultimap.Builder interSccConnectionsBuilder = ImmutableMultimap.builder();
        AtomicBoolean sccHasALoop = new AtomicBoolean(false);
        AtomicBoolean seenAnyInfSet = new AtomicBoolean(false);
        AtomicBoolean seenAllInfSets = new AtomicBoolean(false);
        scc.forEach(state -> this.rabinAutomaton.forEachLabelledEdge(state, (edge, valuations) -> {
            if (scc.contains(edge.successor())) {
                sccHasALoop.lazySet(true);
                if (remainingPairsToCheck.removeIf(pair -> edge.inSet(pair.infSet()))) {
                    seenAnyInfSet.lazySet(true);
                    seenAllInfSets.lazySet(remainingPairsToCheck.isEmpty());
                }
            } else {
                interSccConnectionsBuilder.put(state, LabelledEdge.of(edge, valuations));
            }
        }));
        ImmutableMultimap interSccConnections = interSccConnectionsBuilder.build();
        if (!sccHasALoop.get()) {
            Preconditions.checkState((scc.size() == 1 ? 1 : 0) != 0);
            R transientSccState = scc.iterator().next();
            IARState<R> iarState = IARState.trivial(transientSccState);
            return new SccProcessingResult<R>(interSccConnections, AutomatonFactory.singleton(this.vsFactory, iarState, NoneAcceptance.INSTANCE));
        }
        if (!seenAnyInfSet.get()) {
            return this.getTrivialSccResult(scc, (Multimap<R, LabelledEdge<R>>)interSccConnections);
        }
        Set<GeneralizedRabinAcceptance.RabinPair> activeRabinPairs = seenAllInfSets.get() ? Set.copyOf(rabinPairs) : Set.copyOf(Sets.difference(rabinPairs, remainingPairsToCheck));
        Automaton<IARState<R>, ParityAcceptance> subAutomaton = new SccIARBuilder<R>(Views.filter(Views.replaceInitialState(this.rabinAutomaton, Set.of(scc.iterator().next())), scc, e -> true), activeRabinPairs).build();
        return new SccProcessingResult<R>(interSccConnections, subAutomaton);
    }

    static final class SccProcessingResult<R> {
        final Multimap<R, LabelledEdge<R>> interSccConnections;
        final Automaton<IARState<R>, ?> subAutomaton;

        SccProcessingResult(Multimap<R, LabelledEdge<R>> interSccConnections, Automaton<IARState<R>, ?> subAutomaton) {
            this.interSccConnections = ImmutableMultimap.copyOf(interSccConnections);
            this.subAutomaton = subAutomaton;
        }
    }
}

