/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dra;

import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import owl.automaton.Automaton;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.Views;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.ldba.LimitDeterministicAutomaton;
import owl.automaton.minimizations.MinimizationUtil;
import owl.ltl.EquivalenceClass;
import owl.ltl.LabelledFormula;
import owl.ltl.rewriter.SimplifierFactory;
import owl.run.Environment;
import owl.translations.ldba2dra.MapRankingAutomaton;
import owl.translations.ltl2ldba.LTL2LDBAFunction;
import owl.translations.ltl2ldba.SafetyDetector;
import owl.translations.ltl2ldba.breakpointfree.BooleanLattice;
import owl.translations.ltl2ldba.breakpointfree.DegeneralizedBreakpointFreeState;
import owl.translations.ltl2ldba.breakpointfree.FGObligations;
import owl.translations.ltl2ldba.breakpointfree.GeneralizedBreakpointFreeState;

public class LTL2DRAFunction
implements Function<LabelledFormula, Automaton<?, ? extends GeneralizedRabinAcceptance>> {
    private final EnumSet<Configuration> configuration;
    private final Function<LabelledFormula, LimitDeterministicAutomaton<EquivalenceClass, DegeneralizedBreakpointFreeState, BuchiAcceptance, FGObligations>> translatorBreakpointFree;
    private final Function<LabelledFormula, LimitDeterministicAutomaton<EquivalenceClass, GeneralizedBreakpointFreeState, GeneralizedBuchiAcceptance, FGObligations>> translatorGeneralizedBreakpointFree;

    public LTL2DRAFunction(Environment env, Set<Configuration> configuration) {
        this.configuration = EnumSet.copyOf(configuration);
        EnumSet<LTL2LDBAFunction.Configuration> ldbaConfiguration = EnumSet.of(LTL2LDBAFunction.Configuration.EAGER_UNFOLD, LTL2LDBAFunction.Configuration.EPSILON_TRANSITIONS, LTL2LDBAFunction.Configuration.SUPPRESS_JUMPS);
        if (configuration.contains((Object)Configuration.OPTIMISED_STATE_STRUCTURE)) {
            ldbaConfiguration.add(LTL2LDBAFunction.Configuration.OPTIMISED_STATE_STRUCTURE);
        }
        this.translatorBreakpointFree = LTL2LDBAFunction.createDegeneralizedBreakpointFreeLDBABuilder(env, ldbaConfiguration);
        this.translatorGeneralizedBreakpointFree = LTL2LDBAFunction.createGeneralizedBreakpointFreeLDBABuilder(env, ldbaConfiguration);
    }

    @Override
    public Automaton<?, ? extends GeneralizedRabinAcceptance> apply(LabelledFormula formula) {
        LabelledFormula formula2 = SimplifierFactory.apply(formula, SimplifierFactory.Mode.SYNTACTIC_FIXPOINT);
        Automaton<?, GeneralizedRabinAcceptance> automaton = this.configuration.contains((Object)Configuration.DEGENERALIZE) ? this.applyDegeneralized(formula2) : this.applyGeneralized(formula2);
        return MinimizationUtil.minimizeDefault(MutableAutomatonUtil.asMutable(automaton), MinimizationUtil.MinimizationLevel.ALL);
    }

    private Automaton<?, RabinAcceptance> applyDegeneralized(LabelledFormula formula) {
        LimitDeterministicAutomaton<EquivalenceClass, DegeneralizedBreakpointFreeState, BuchiAcceptance, FGObligations> ldba = this.translatorBreakpointFree.apply(formula);
        if (ldba.isDeterministic()) {
            return Views.viewAs(ldba.acceptingComponent(), RabinAcceptance.class);
        }
        return MapRankingAutomaton.of(ldba, new BooleanLattice(), x -> SafetyDetector.hasSafetyCore(x, this.configuration.contains((Object)Configuration.EXISTS_SAFETY_CORE)), true, this.configuration.contains((Object)Configuration.OPTIMISE_INITIAL_STATE));
    }

    private Automaton<?, GeneralizedRabinAcceptance> applyGeneralized(LabelledFormula formula) {
        LimitDeterministicAutomaton<EquivalenceClass, GeneralizedBreakpointFreeState, GeneralizedBuchiAcceptance, FGObligations> ldba = this.translatorGeneralizedBreakpointFree.apply(formula);
        if (ldba.isDeterministic()) {
            return Views.viewAs(ldba.acceptingComponent(), GeneralizedRabinAcceptance.class);
        }
        return MapRankingAutomaton.of(ldba, new BooleanLattice(), x -> SafetyDetector.hasSafetyCore(x, this.configuration.contains((Object)Configuration.EXISTS_SAFETY_CORE)), true, this.configuration.contains((Object)Configuration.OPTIMISE_INITIAL_STATE));
    }

    public static enum Configuration {
        OPTIMISE_INITIAL_STATE,
        OPTIMISED_STATE_STRUCTURE,
        EXISTS_SAFETY_CORE,
        DEGENERALIZE;

    }
}

