/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba.breakpoint;

import owl.factories.EquivalenceClassFactory;
import owl.ltl.EquivalenceClass;
import owl.ltl.SyntacticFragment;
import owl.translations.ldba2dpa.Language;
import owl.translations.ldba2dpa.LanguageLattice;
import owl.translations.ltl2ldba.breakpoint.DegeneralizedBreakpointState;
import owl.translations.ltl2ldba.breakpoint.GObligations;

public class EquivalenceClassLanguageLattice
implements LanguageLattice<DegeneralizedBreakpointState, GObligations, EquivalenceClass> {
    private final EquivalenceClassFactory eqFactory;

    public EquivalenceClassLanguageLattice(EquivalenceClassFactory eqFactory) {
        this.eqFactory = eqFactory;
    }

    @Override
    public Language<EquivalenceClass> getBottom() {
        return new EquivalenceClassLanguage(this.eqFactory.getFalse());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean acceptsLivenessLanguage(DegeneralizedBreakpointState state) {
        if (!this.isLivenessLanguage(state.obligations)) return false;
        if (state.next.length != 0) return false;
        if (!state.safety.isTrue()) return false;
        if (!state.current.modalOperators().stream().allMatch(SyntacticFragment.CO_SAFETY::contains)) return false;
        return true;
    }

    @Override
    public Language<EquivalenceClass> getTop() {
        return new EquivalenceClassLanguage(this.eqFactory.getTrue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean acceptsSafetyLanguage(DegeneralizedBreakpointState state) {
        if (!this.isSafetyAnnotation(state.obligations)) return false;
        if (state.next.length != 0) return false;
        if (!state.current.modalOperators().stream().allMatch(SyntacticFragment.SAFETY::contains)) return false;
        return true;
    }

    @Override
    public Language<EquivalenceClass> getLanguage(DegeneralizedBreakpointState state) {
        return new EquivalenceClassLanguage(state.getLabel());
    }

    @Override
    public boolean isLivenessLanguage(GObligations annotation) {
        return annotation.obligations().isEmpty() && annotation.safety().isTrue();
    }

    @Override
    public boolean isSafetyAnnotation(GObligations annotation) {
        return annotation.obligations().isEmpty() && annotation.liveness().isEmpty();
    }

    private static class EquivalenceClassLanguage
    implements Language<EquivalenceClass> {
        private final EquivalenceClass eq;

        EquivalenceClassLanguage(EquivalenceClass eq) {
            this.eq = eq;
        }

        @Override
        public EquivalenceClass getT() {
            return this.eq;
        }

        @Override
        public boolean greaterOrEqual(Language<EquivalenceClass> language) {
            return language.getT().implies(this.eq);
        }

        @Override
        public boolean isBottom() {
            return this.eq.isFalse();
        }

        @Override
        public boolean isTop() {
            return this.eq.isTrue();
        }

        @Override
        public Language<EquivalenceClass> join(Language<EquivalenceClass> language) {
            return new EquivalenceClassLanguage(this.eq.or(language.getT()));
        }
    }
}

