/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.rabinizer;

import com.google.common.collect.Iterables;
import de.tum.in.naturals.bitset.BitSets;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import owl.automaton.Automaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.collections.ValuationSet;
import owl.factories.ValuationSetFactory;
import owl.ltl.EquivalenceClass;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.SyntacticFragment;
import owl.translations.rabinizer.GSet;
import owl.translations.rabinizer.MonitorAutomaton;
import owl.translations.rabinizer.MonitorState;
import owl.translations.rabinizer.MonitorStateFactory;

final class MonitorBuilder {
    private static final Logger logger = Logger.getLogger(MonitorBuilder.class.getName());
    private static final GSet[] EMPTY = new GSet[0];
    private final EquivalenceClass initialClass;
    private final Fragment fragment;
    private final MutableAutomaton<MonitorState, ParityAcceptance>[] monitorAutomata;
    private final GSet[] relevantSets;
    private final MonitorStateFactory stateFactory;
    private final GOperator gOperator;
    private final ValuationSetFactory vsFactory;

    private MonitorBuilder(GOperator gOperator, EquivalenceClass operand, Collection<GSet> relevantSets, ValuationSetFactory vsFactory, boolean eager) {
        this.gOperator = gOperator;
        this.vsFactory = vsFactory;
        Set<Formula> modalOperators = operand.modalOperators();
        boolean isCoSafety = modalOperators.stream().allMatch(SyntacticFragment.CO_SAFETY::contains);
        this.fragment = isCoSafety && gOperator.operand instanceof FOperator ? Fragment.EVENTUAL : (modalOperators.stream().allMatch(SyntacticFragment.FINITE::contains) ? Fragment.FINITE : Fragment.FULL);
        logger.log(Level.FINE, "Creating builder for formula {0} and relevant sets {1}; fragment: {2}, no G-sub: {3}", new Object[]{operand, relevantSets, this.fragment, isCoSafety});
        this.stateFactory = new MonitorStateFactory(eager, isCoSafety);
        this.relevantSets = relevantSets.toArray(EMPTY);
        assert (!isCoSafety || this.relevantSets.length == 1);
        this.monitorAutomata = new MutableAutomaton[this.relevantSets.length];
        this.initialClass = this.stateFactory.getInitialState(operand);
    }

    static MonitorAutomaton create(GOperator gOperator, EquivalenceClass operand, Collection<GSet> relevantSets, ValuationSetFactory vsFactory, boolean eager) {
        return new MonitorBuilder(gOperator, operand, relevantSets, vsFactory, eager).build();
    }

    private static int fail() {
        return 0;
    }

    private static int merge(int i) {
        return 2 * i;
    }

    private static int succeed(int i) {
        return 2 * i + 1;
    }

    private static int none() {
        return Integer.MAX_VALUE;
    }

    private MonitorAutomaton build() {
        boolean[] initialAccepting;
        MonitorState initialState = MonitorState.of(this.initialClass);
        for (int i = 0; i < this.monitorAutomata.length; ++i) {
            MutableAutomaton<MonitorState, ParityAcceptance> monitor = MutableAutomatonFactory.create(new ParityAcceptance(0, ParityAcceptance.Parity.MIN_ODD), this.vsFactory);
            monitor.name(String.format("Monitor for %s with %s", this.initialClass, this.relevantSets[i]));
            monitor.addInitialState(initialState);
            this.monitorAutomata[i] = monitor;
        }
        int numberOfRelevantSets = this.relevantSets.length;
        if (this.fragment == Fragment.FULL) {
            initialAccepting = new boolean[numberOfRelevantSets];
            for (int gIndex = 0; gIndex < this.relevantSets.length; ++gIndex) {
                initialAccepting[gIndex] = MonitorStateFactory.isAccepting(this.initialClass, this.relevantSets[gIndex]);
            }
        } else {
            initialAccepting = BooleanArrays.EMPTY_ARRAY;
        }
        int[] maximalPriority = new int[numberOfRelevantSets];
        Arrays.fill(maximalPriority, -1);
        logger.log(Level.FINER, "Exploring monitor transition system");
        HashSet<MonitorState> exploredStates = new HashSet<MonitorState>(List.of(initialState));
        ArrayDeque<MonitorState> workQueue = new ArrayDeque<MonitorState>(exploredStates);
        int[] priorities = new int[numberOfRelevantSets];
        while (!workQueue.isEmpty()) {
            MonitorState currentState = (MonitorState)workQueue.poll();
            BitSet sensitiveAlphabet = this.stateFactory.getSensitiveAlphabet(currentState);
            for (BitSet valuation : BitSets.powerSet((BitSet)sensitiveAlphabet)) {
                MonitorState successorState;
                switch (this.fragment) {
                    case FINITE: {
                        successorState = this.getSuccessorFiniteFragment(currentState, valuation, priorities);
                        break;
                    }
                    case EVENTUAL: {
                        successorState = this.getSuccessorEventualFragment(currentState, valuation, priorities);
                        break;
                    }
                    default: {
                        Arrays.fill(priorities, MonitorBuilder.none());
                        successorState = this.getSuccessor(currentState, valuation, priorities, initialAccepting);
                    }
                }
                if (exploredStates.add(successorState)) {
                    workQueue.add(successorState);
                }
                ValuationSet valuationSet = this.vsFactory.of(valuation, sensitiveAlphabet);
                for (int contextIndex = 0; contextIndex < this.relevantSets.length; ++contextIndex) {
                    Edge<MonitorState> edge;
                    int priority = priorities[contextIndex];
                    if (priority == MonitorBuilder.none()) {
                        edge = Edge.of(successorState);
                    } else {
                        edge = Edge.of(successorState, priority);
                        if (maximalPriority[contextIndex] < priority) {
                            maximalPriority[contextIndex] = priority;
                        }
                    }
                    this.monitorAutomata[contextIndex].addEdge(currentState, valuationSet, edge);
                }
            }
            sensitiveAlphabet.clear();
        }
        if (this.fragment == Fragment.FULL) {
            this.optimizeInitialState();
        }
        HashMap<GSet, Automaton<MonitorState, ParityAcceptance>> builder = new HashMap<GSet, Automaton<MonitorState, ParityAcceptance>>();
        for (int contextIndex = 0; contextIndex < this.relevantSets.length; ++contextIndex) {
            MutableAutomaton<MonitorState, ParityAcceptance> monitor = this.monitorAutomata[contextIndex];
            int sets = maximalPriority[contextIndex];
            monitor.updateAcceptance(x -> x.withAcceptanceSets(sets + 1));
            builder.put(this.relevantSets[contextIndex], monitor);
            assert (monitor.is(Automaton.Property.DETERMINISTIC)) : String.format("%s monitor for %s is not deterministic", this.relevantSets[contextIndex], this.initialClass);
        }
        return new MonitorAutomaton(this.gOperator, builder);
    }

    private MonitorState getSuccessor(MonitorState currentState, BitSet valuation, int[] priorities, boolean[] initialAccepting) {
        List<EquivalenceClass> currentRanking = currentState.formulaRanking();
        int currentRankingSize = currentRanking.size();
        int numberOfRelevantSets = this.relevantSets.length;
        for (int contextIndex = 0; contextIndex < numberOfRelevantSets; ++contextIndex) {
            if (!initialAccepting[contextIndex]) continue;
            priorities[contextIndex] = MonitorBuilder.succeed(0);
        }
        ArrayList<EquivalenceClass> successorRanking = new ArrayList<EquivalenceClass>(currentRankingSize + 1);
        int[] successorSources = new int[currentRankingSize];
        int successorRankingSize = 0;
        boolean successorContainsInitial = false;
        for (int currentRank = 0; currentRank < currentRankingSize; ++currentRank) {
            assert (successorRankingSize <= currentRank);
            EquivalenceClass currentClass = currentRanking.get(currentRank);
            EquivalenceClass successorClass = this.stateFactory.getRankSuccessor(currentClass, valuation);
            if (successorClass.isFalse()) {
                assert (MonitorStateFactory.isSink(successorClass) && Arrays.stream(this.relevantSets).noneMatch(set -> MonitorStateFactory.isAccepting(successorClass, set)));
                Arrays.fill(priorities, MonitorBuilder.fail());
                continue;
            }
            if (successorClass.equals(this.initialClass)) {
                if (successorContainsInitial) {
                    assert (Arrays.stream(priorities).allMatch(priority -> priority < Integer.MAX_VALUE));
                    continue;
                }
                successorContainsInitial = true;
                for (int contextIndex = 0; contextIndex < numberOfRelevantSets; ++contextIndex) {
                    if (priorities[contextIndex] < Integer.MAX_VALUE) continue;
                    assert (!initialAccepting[contextIndex]);
                    priorities[contextIndex] = MonitorBuilder.merge(currentRank + 1);
                }
            } else {
                int contextIndex;
                boolean merged = false;
                for (int olderIndex = 0; olderIndex < successorRankingSize; ++olderIndex) {
                    EquivalenceClass olderSuccessorClass = (EquivalenceClass)successorRanking.get(olderIndex);
                    assert (olderSuccessorClass != null && !MonitorStateFactory.isSink(olderSuccessorClass));
                    if (!successorClass.equals(olderSuccessorClass)) continue;
                    merged = true;
                    assert (!MonitorStateFactory.isSink(olderSuccessorClass));
                    int olderSource = successorSources[olderIndex];
                    int mergePriority = MonitorBuilder.merge(olderSource + 1);
                    for (int contextIndex2 = 0; contextIndex2 < numberOfRelevantSets; ++contextIndex2) {
                        if (priorities[contextIndex2] <= mergePriority || MonitorStateFactory.isAccepting(currentClass, this.relevantSets[contextIndex2])) continue;
                        if (MonitorStateFactory.isAccepting(olderSuccessorClass, this.relevantSets[contextIndex2])) {
                            assert (MonitorStateFactory.isAccepting(currentRanking.get(olderSource), this.relevantSets[contextIndex2]));
                            if (priorities[contextIndex2] != MonitorBuilder.none()) continue;
                            priorities[contextIndex2] = MonitorBuilder.succeed(currentRank);
                            continue;
                        }
                        priorities[contextIndex2] = mergePriority;
                    }
                    break;
                }
                if (merged) continue;
                if (MonitorStateFactory.isSink(successorClass)) {
                    for (contextIndex = 0; contextIndex < this.relevantSets.length; ++contextIndex) {
                        GSet contextSet = this.relevantSets[contextIndex];
                        if (MonitorStateFactory.isAccepting(successorClass, contextSet)) {
                            if (priorities[contextIndex] != MonitorBuilder.none() || MonitorStateFactory.isAccepting(currentClass, contextSet)) continue;
                            priorities[contextIndex] = MonitorBuilder.succeed(currentRank);
                            continue;
                        }
                        priorities[contextIndex] = MonitorBuilder.fail();
                    }
                    continue;
                }
                for (contextIndex = 0; contextIndex < this.relevantSets.length; ++contextIndex) {
                    if (priorities[contextIndex] != MonitorBuilder.none() || MonitorStateFactory.isAccepting(currentClass, this.relevantSets[contextIndex]) || !MonitorStateFactory.isAccepting(successorClass, this.relevantSets[contextIndex])) continue;
                    priorities[contextIndex] = MonitorBuilder.succeed(currentRank);
                }
            }
            successorRanking.add(successorClass);
            successorSources[successorRankingSize] = currentRank;
            ++successorRankingSize;
        }
        assert (successorContainsInitial == successorRanking.contains(this.initialClass));
        if (!successorContainsInitial) {
            successorRanking.add(this.initialClass);
        }
        assert (successorRanking.stream().noneMatch(MonitorStateFactory::isSink));
        assert (successorRanking.stream().filter(state -> state.equals(this.initialClass)).count() == 1L);
        return MonitorState.of(successorRanking);
    }

    private MonitorState getSuccessorFiniteFragment(MonitorState currentState, BitSet valuation, int[] priorities) {
        EquivalenceClass successorRanking;
        EquivalenceClass currentRanking = (EquivalenceClass)Iterables.getOnlyElement(currentState.formulaRanking());
        EquivalenceClass successorClass = this.stateFactory.getRankSuccessor(currentRanking, valuation);
        if (successorClass.isFalse()) {
            priorities[0] = MonitorBuilder.fail();
            successorRanking = this.initialClass;
        } else {
            priorities[0] = MonitorBuilder.succeed(0);
            successorRanking = successorClass.and(this.initialClass);
        }
        return MonitorState.of(successorRanking);
    }

    private MonitorState getSuccessorEventualFragment(MonitorState currentState, BitSet valuation, int[] priorities) {
        EquivalenceClass currentRanking = (EquivalenceClass)Iterables.getOnlyElement(currentState.formulaRanking());
        EquivalenceClass successorClass = this.stateFactory.getRankSuccessor(currentRanking, valuation);
        EquivalenceClass successorRanking = null;
        for (int contextIndex = 0; contextIndex < this.relevantSets.length; ++contextIndex) {
            if (MonitorStateFactory.isAccepting(successorClass, this.relevantSets[contextIndex])) {
                priorities[contextIndex] = MonitorBuilder.succeed(0);
                successorRanking = this.initialClass;
                continue;
            }
            priorities[contextIndex] = MonitorBuilder.none();
            successorRanking = successorClass;
        }
        assert (successorRanking != null);
        return MonitorState.of(successorRanking);
    }

    private void optimizeInitialState() {
        MonitorState optimizedInitialState;
        MutableAutomaton<MonitorState, ParityAcceptance> anyMonitor = this.monitorAutomata[0];
        List<Set<MonitorState>> sccs = SccDecomposition.computeSccs(anyMonitor, false);
        BitSet valuation = new BitSet(0);
        Predicate<MonitorState> isTransient = state -> sccs.parallelStream().noneMatch(scc -> scc.contains(state));
        MonitorState nextOptimizedInitialState = (MonitorState)anyMonitor.onlyInitialState();
        while ((nextOptimizedInitialState = isTransient.test(optimizedInitialState = nextOptimizedInitialState) ? anyMonitor.successor(optimizedInitialState, valuation) : null) != null) {
        }
        if (optimizedInitialState.equals(anyMonitor.onlyInitialState())) {
            logger.log(Level.FINER, "No better initial state found");
        } else {
            logger.log(Level.FINER, "Updating initial state from {0} to {1}", new Object[]{anyMonitor.onlyInitialState(), optimizedInitialState});
            for (MutableAutomaton<MonitorState, ParityAcceptance> monitor : this.monitorAutomata) {
                monitor.initialStates(Set.of(optimizedInitialState));
                monitor.trim();
            }
        }
    }

    private static enum Fragment {
        EVENTUAL,
        FINITE,
        FULL;

    }
}

