/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.robust;

import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import org.immutables.value.Value;
import owl.ltl.BooleanConstant;
import owl.ltl.Formula;
import owl.ltl.robust.Robustness;
import owl.ltl.robust.SplitTuple;
import owl.util.annotation.Tuple;

@Tuple
@Value.Immutable
public abstract class Split {
    public static final Split TRUE = Split.of(BooleanConstant.TRUE, true);
    public static final Split FALSE = Split.of(BooleanConstant.FALSE, true);

    public abstract Formula always();

    public abstract Formula eventuallyAlways();

    public abstract Formula infinitelyOften();

    public abstract Formula eventually();

    @Value.Auxiliary
    abstract boolean grFree();

    static Split of(Formula formula, boolean grFree) {
        return SplitTuple.create(formula, formula, formula, formula, grFree);
    }

    static Split of(Formula first, Formula second, Formula third, Formula fourth, boolean grFree) {
        return SplitTuple.create(first, second, third, fourth, grFree);
    }

    public static BinaryOperator<Split> combiner(BinaryOperator<Formula> formulaCombiner) {
        return (one, other) -> Split.of((Formula)formulaCombiner.apply(one.always(), other.always()), (Formula)formulaCombiner.apply(one.eventuallyAlways(), other.eventuallyAlways()), (Formula)formulaCombiner.apply(one.infinitelyOften(), other.infinitelyOften()), (Formula)formulaCombiner.apply(one.eventually(), other.eventually()), one.grFree() && other.grFree());
    }

    public Split map(UnaryOperator<Formula> map) {
        return this.map(map, this.grFree());
    }

    public Split map(UnaryOperator<Formula> map, boolean grFree) {
        return Split.of((Formula)map.apply(this.always()), (Formula)map.apply(this.eventuallyAlways()), (Formula)map.apply(this.infinitelyOften()), (Formula)map.apply(this.eventually()), grFree);
    }

    public List<Formula> all() {
        return List.of(this.always(), this.eventuallyAlways(), this.infinitelyOften(), this.eventually());
    }

    public Formula get(Robustness level) {
        switch (level) {
            case ALWAYS: {
                return this.always();
            }
            case EVENTUALLY_ALWAYS: {
                return this.eventuallyAlways();
            }
            case INFINITELY_OFTEN: {
                return this.infinitelyOften();
            }
            case EVENTUALLY: {
                return this.eventually();
            }
            case NEVER: {
                return this.eventually().not();
            }
        }
        throw new AssertionError();
    }

    public String toString() {
        return "G: " + this.always() + " FG: " + this.eventuallyAlways() + " GF: " + this.infinitelyOften() + " F: " + this.eventually();
    }
}

