/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.delag;

import java.util.HashMap;
import java.util.Map;
import org.immutables.value.Value;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.translations.delag.DependencyTree;
import owl.translations.delag.ProductStateTuple;
import owl.util.annotation.HashedTuple;

@Value.Immutable
@HashedTuple
abstract class ProductState<T> {
    ProductState() {
    }

    abstract Map<Formula, T> fallback();

    abstract Map<DependencyTree<T>, Boolean> finished();

    abstract Map<Formula, EquivalenceClass> safety();

    static <T> Builder<T> builder() {
        return new Builder();
    }

    static final class Builder<T> {
        private final Map<Formula, T> fallback = new HashMap<Formula, T>();
        private final Map<DependencyTree<T>, Boolean> finished = new HashMap<DependencyTree<T>, Boolean>();
        private final Map<Formula, EquivalenceClass> safety = new HashMap<Formula, EquivalenceClass>();

        Builder() {
        }

        ProductState<T> build() {
            return ProductStateTuple.create(this.fallback, this.finished, this.safety);
        }

        void merge(Builder<T> other) {
            other.fallback.forEach(this::addFallback);
            other.finished.forEach(this::addFinished);
            other.safety.forEach(this::addSafety);
        }

        private static <K, V> void add(Map<K, V> map, K key, V value) {
            V oldValue = map.put(key, value);
            assert (oldValue == null || value.equals(oldValue));
        }

        void addFallback(Formula key, T value) {
            Builder.add(this.fallback, key, value);
        }

        void addSafety(Formula key, EquivalenceClass value) {
            Builder.add(this.safety, key, value);
        }

        void addFinished(DependencyTree<T> tree, Boolean value) {
            Builder.add(this.finished, tree, value);
        }
    }
}

