/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.fgx2dpa;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.UnaryModalOperator;
import owl.translations.fgx2dpa.PromisedSet;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PromisedSet", generator="Immutables")
@Immutable
final class PromisedSetTuple
extends PromisedSet {
    private final ImmutableSet<GOperator> formulaeG;
    private final ImmutableList<FOperator> formulaeF;
    private final Formula firstF;
    private final transient long nonFinalGCount;
    private final transient Set<UnaryModalOperator> union;
    private final transient int hashCode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private PromisedSetTuple(Iterable<? extends GOperator> formulaeG, Iterable<? extends FOperator> formulaeF, Formula firstF) {
        this.formulaeG = ImmutableSet.copyOf(formulaeG);
        this.formulaeF = ImmutableList.copyOf(formulaeF);
        this.firstF = Objects.requireNonNull(firstF, "firstF");
        this.nonFinalGCount = this.initShim.nonFinalGCount();
        this.union = this.initShim.union();
        this.hashCode = this.computeHashCode();
        this.initShim = null;
    }

    ImmutableSet<GOperator> formulaeG() {
        return this.formulaeG;
    }

    ImmutableList<FOperator> formulaeF() {
        return this.formulaeF;
    }

    @Override
    Formula firstF() {
        return this.firstF;
    }

    @Override
    long nonFinalGCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nonFinalGCount() : this.nonFinalGCount;
    }

    @Override
    Set<UnaryModalOperator> union() {
        InitShim shim = this.initShim;
        return shim != null ? shim.union() : this.union;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PromisedSetTuple && this.equalTo((PromisedSetTuple)another);
    }

    private boolean equalTo(PromisedSetTuple another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.formulaeG.equals(another.formulaeG) && this.formulaeF.equals(another.formulaeF) && this.firstF.equals(another.firstF);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.formulaeG.hashCode();
        h += (h << 5) + this.formulaeF.hashCode();
        h += (h << 5) + this.firstF.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PromisedSet").omitNullValues().add("formulaeG", this.formulaeG).add("formulaeF", this.formulaeF).add("firstF", (Object)this.firstF).toString();
    }

    public static PromisedSetTuple create(Set<GOperator> formulaeG, List<FOperator> formulaeF, Formula firstF) {
        return PromisedSetTuple.create(formulaeG, formulaeF, firstF);
    }

    public static PromisedSetTuple create(Iterable<? extends GOperator> formulaeG, Iterable<? extends FOperator> formulaeF, Formula firstF) {
        return new PromisedSetTuple(formulaeG, formulaeF, firstF);
    }

    private final class InitShim {
        private byte nonFinalGCountBuildStage = 0;
        private long nonFinalGCount;
        private byte unionBuildStage = 0;
        private Set<UnaryModalOperator> union;

        private InitShim() {
        }

        long nonFinalGCount() {
            if (this.nonFinalGCountBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nonFinalGCountBuildStage == 0) {
                this.nonFinalGCountBuildStage = (byte)-1;
                this.nonFinalGCount = PromisedSetTuple.super.nonFinalGCount();
                this.nonFinalGCountBuildStage = 1;
            }
            return this.nonFinalGCount;
        }

        Set<UnaryModalOperator> union() {
            if (this.unionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.unionBuildStage == 0) {
                this.unionBuildStage = (byte)-1;
                this.union = Objects.requireNonNull(PromisedSetTuple.super.union(), "union");
                this.unionBuildStage = 1;
            }
            return this.union;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.nonFinalGCountBuildStage == -1) {
                attributes.add("nonFinalGCount");
            }
            if (this.unionBuildStage == -1) {
                attributes.add("union");
            }
            return "Cannot build PromisedSet, attribute initializers form cycle " + attributes;
        }
    }
}

