/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.mastertheorem;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import owl.factories.EquivalenceClassFactory;
import owl.factories.Factories;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.Formulas;
import owl.ltl.GOperator;
import owl.ltl.LtlLanguageExpressible;
import owl.ltl.XOperator;
import owl.ltl.rewriter.NormalForms;
import owl.ltl.rewriter.SimplifierFactory;
import owl.translations.canonical.DeterministicConstructions;
import owl.translations.canonical.NonDeterministicConstructions;
import owl.translations.mastertheorem.Fixpoints;
import owl.translations.mastertheorem.Rewriter;

public final class SymmetricEvaluatedFixpoints
implements Comparable<SymmetricEvaluatedFixpoints>,
LtlLanguageExpressible {
    public final Fixpoints fixpoints;
    public final Set<FOperator> almostAlways;
    public final Set<GOperator> infinitelyOften;
    private final EquivalenceClass language;

    private SymmetricEvaluatedFixpoints(Fixpoints fixpoints, Collection<FOperator> almostAlways, Collection<GOperator> infinitelyOften, EquivalenceClass language) {
        this.fixpoints = fixpoints;
        this.almostAlways = Set.copyOf(almostAlways);
        this.infinitelyOften = Set.copyOf(infinitelyOften);
        this.language = language;
    }

    public static Set<SymmetricEvaluatedFixpoints> build(Fixpoints fixpoints, Factories factories) {
        Rewriter.ToCoSafety toCoSafety = new Rewriter.ToCoSafety(fixpoints);
        Rewriter.ToSafety toSafety = new Rewriter.ToSafety(fixpoints);
        Set<Object> infinitelyOftenFormulas = new HashSet();
        for (Formula.ModalOperator modalOperator : fixpoints.leastFixpoints()) {
            Formula infinitelyOften = SymmetricEvaluatedFixpoints.unwrapX(SimplifierFactory.apply(GOperator.of(FOperator.of(toCoSafety.apply(modalOperator))), SimplifierFactory.Mode.SYNTACTIC_FIXPOINT, SimplifierFactory.Mode.PULL_UP_X));
            if (infinitelyOften.equals(BooleanConstant.TRUE)) continue;
            if (infinitelyOften.equals(BooleanConstant.FALSE)) {
                return Set.of();
            }
            for (Set<Formula> clause : NormalForms.toCnf(infinitelyOften)) {
                assert (!clause.isEmpty());
                Formula disjunction = Disjunction.of(clause.stream().map(SymmetricEvaluatedFixpoints::unwrapGf));
                assert (!(disjunction instanceof BooleanConstant));
                infinitelyOftenFormulas.add(SymmetricEvaluatedFixpoints.wrapGf(disjunction));
            }
        }
        infinitelyOftenFormulas = Set.of((GOperator[])infinitelyOftenFormulas.toArray(GOperator[]::new));
        ArrayList almostAlwaysFormulasAlternatives = new ArrayList();
        for (Formula.ModalOperator greatestFixpoint : fixpoints.greatestFixpoints()) {
            Formula almostAlways = SymmetricEvaluatedFixpoints.unwrapX(SimplifierFactory.apply(FOperator.of(GOperator.of(toSafety.apply(greatestFixpoint))), SimplifierFactory.Mode.SYNTACTIC_FIXPOINT, SimplifierFactory.Mode.PULL_UP_X));
            if (almostAlways.equals(BooleanConstant.TRUE)) continue;
            if (almostAlways.equals(BooleanConstant.FALSE)) {
                return Set.of();
            }
            HashSet<FOperator> alternatives = new HashSet<FOperator>();
            for (Set set : NormalForms.toDnf(almostAlways)) {
                assert (!set.isEmpty());
                Formula conjunction = Conjunction.of(set.stream().map(SymmetricEvaluatedFixpoints::unwrapFg));
                assert (!(conjunction instanceof BooleanConstant));
                alternatives.add(SymmetricEvaluatedFixpoints.wrapFg(conjunction));
            }
            assert (!alternatives.isEmpty());
            almostAlwaysFormulasAlternatives.add(alternatives);
        }
        HashSet<SymmetricEvaluatedFixpoints> hashSet = new HashSet<SymmetricEvaluatedFixpoints>();
        Iterator iterator = Sets.cartesianProduct(almostAlwaysFormulasAlternatives).iterator();
        while (iterator.hasNext()) {
            EquivalenceClassFactory factory = factories.eqFactory;
            List almostAlwaysFormulas = (List)iterator.next();
            Formula formula = Conjunction.of(Stream.concat(almostAlwaysFormulas.stream().map(x -> x.operand), infinitelyOftenFormulas.stream()));
            EquivalenceClass equivalenceClass = factory.of(formula.unfold());
            if (equivalenceClass.isFalse()) continue;
            hashSet.add(new SymmetricEvaluatedFixpoints(fixpoints, almostAlwaysFormulas, infinitelyOftenFormulas, equivalenceClass));
        }
        return hashSet;
    }

    @Override
    public int compareTo(SymmetricEvaluatedFixpoints that) {
        int comparison = Formulas.compare(this.infinitelyOften, that.infinitelyOften);
        if (comparison != 0) {
            return -comparison;
        }
        comparison = Formulas.compare(this.almostAlways, that.almostAlways);
        if (comparison != 0) {
            return comparison;
        }
        return this.fixpoints.compareTo(that.fixpoints);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SymmetricEvaluatedFixpoints)) {
            return false;
        }
        SymmetricEvaluatedFixpoints that = (SymmetricEvaluatedFixpoints)o;
        return this.fixpoints.equals(that.fixpoints) && this.almostAlways.equals(that.almostAlways) && this.infinitelyOften.equals(that.infinitelyOften);
    }

    public int hashCode() {
        return Objects.hash(this.fixpoints, this.almostAlways, this.infinitelyOften);
    }

    public boolean isEmpty() {
        return this.almostAlways.isEmpty() && this.infinitelyOften.isEmpty();
    }

    public boolean isSafety() {
        return this.infinitelyOften.isEmpty();
    }

    public boolean isLiveness() {
        return this.almostAlways.isEmpty();
    }

    @Override
    public EquivalenceClass language() {
        return this.language;
    }

    public String toString() {
        return "<" + this.almostAlways + ", " + this.infinitelyOften + ">";
    }

    public DeterministicAutomata deterministicAutomata(Factories factories, boolean unfold, boolean generalized) {
        DeterministicConstructions.GfCoSafety gfCoSafetyAutomaton;
        DeterministicConstructions.Safety safetyAutomaton = new DeterministicConstructions.Safety(factories, unfold, Conjunction.of(this.almostAlways.stream().map(x -> x.operand)));
        DeterministicConstructions.GfCoSafety gfCoSafety = gfCoSafetyAutomaton = this.infinitelyOften.isEmpty() ? null : new DeterministicConstructions.GfCoSafety(factories, unfold, new TreeSet<GOperator>(this.infinitelyOften), generalized);
        assert (!safetyAutomaton.onlyInitialState().isFalse());
        return new DeterministicAutomata(gfCoSafetyAutomaton, safetyAutomaton);
    }

    public NonDeterministicAutomata nonDeterministicAutomata(Factories factories, boolean generalized) {
        NonDeterministicConstructions.Safety safetyAutomaton = new NonDeterministicConstructions.Safety(factories, Conjunction.of(this.almostAlways.stream().map(x -> x.operand)));
        NonDeterministicConstructions.GfCoSafety gfCoSafetyAutomaton = this.infinitelyOften.isEmpty() ? null : new NonDeterministicConstructions.GfCoSafety(factories, new TreeSet<GOperator>(this.infinitelyOften), generalized);
        return new NonDeterministicAutomata(gfCoSafetyAutomaton, safetyAutomaton);
    }

    private static Formula unwrapFg(Formula formula) {
        return ((GOperator)((FOperator)formula).operand).operand;
    }

    private static Formula unwrapGf(Formula formula) {
        return ((FOperator)((GOperator)formula).operand).operand;
    }

    private static Formula unwrapX(Formula formula) {
        Formula unwrappedFormula = formula;
        while (unwrappedFormula instanceof XOperator) {
            unwrappedFormula = ((XOperator)unwrappedFormula).operand;
        }
        return unwrappedFormula;
    }

    private static FOperator wrapFg(Formula formula) {
        if (formula instanceof FOperator && ((FOperator)formula).operand instanceof GOperator) {
            return (FOperator)formula;
        }
        return formula instanceof GOperator ? new FOperator(formula) : new FOperator(new GOperator(formula));
    }

    private static GOperator wrapGf(Formula formula) {
        if (formula instanceof GOperator && ((GOperator)formula).operand instanceof FOperator) {
            return (GOperator)formula;
        }
        return formula instanceof FOperator ? new GOperator(formula) : new GOperator(new FOperator(formula));
    }

    public static final class NonDeterministicAutomata {
        @Nullable
        public final NonDeterministicConstructions.GfCoSafety gfCoSafetyAutomaton;
        public final NonDeterministicConstructions.Safety safetyAutomaton;

        private NonDeterministicAutomata(@Nullable NonDeterministicConstructions.GfCoSafety gfCoSafetyAutomaton, NonDeterministicConstructions.Safety safetyAutomaton) {
            this.gfCoSafetyAutomaton = gfCoSafetyAutomaton;
            this.safetyAutomaton = safetyAutomaton;
        }
    }

    public static final class DeterministicAutomata {
        @Nullable
        public final DeterministicConstructions.GfCoSafety gfCoSafetyAutomaton;
        public final DeterministicConstructions.Safety safetyAutomaton;

        private DeterministicAutomata(@Nullable DeterministicConstructions.GfCoSafety gfCoSafetyAutomaton, DeterministicConstructions.Safety safetyAutomaton) {
            this.gfCoSafetyAutomaton = gfCoSafetyAutomaton;
            this.safetyAutomaton = safetyAutomaton;
        }
    }
}

