/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PropertyFilter {
    private static Set<String> v1LanguageProperties = PropertyFilter.getV1LanguageProperties();
    private static Set<String> v1SyntaxProperties = PropertyFilter.getV1SyntaxProperties();
    private static Set<String> v1BranchingProperties = PropertyFilter.getV1BranchingProperties();
    private static Set<String> v1StructuralProperties = PropertyFilter.getV1StructuralProperties();
    private Set<String> allowedProperties = new HashSet<String>();

    public PropertyFilter(boolean preservesLanguage, boolean preservesSyntax, boolean preservesBranching, boolean preservesStructure) {
        if (preservesLanguage) {
            this.allowedProperties.addAll(v1LanguageProperties);
        }
        if (preservesSyntax) {
            this.allowedProperties.addAll(v1SyntaxProperties);
        }
        if (preservesBranching) {
            this.allowedProperties.addAll(v1BranchingProperties);
        }
        if (preservesStructure) {
            this.allowedProperties.addAll(v1StructuralProperties);
        }
    }

    public void allowProperty(String property) {
        this.allowedProperties.add(property);
    }

    public void disallowProperty(String property) {
        this.allowedProperties.remove(property);
    }

    public boolean isFiltered(String property) {
        return !this.allowedProperties.contains(property);
    }

    public List<String> filter(Collection<String> properties) {
        ArrayList<String> result = new ArrayList<String>();
        for (String property : properties) {
            if (this.isFiltered(property)) continue;
            result.add(property);
        }
        return result;
    }

    public static Set<String> getV1LanguageProperties() {
        HashSet<String> properties = new HashSet<String>();
        properties.add("stutter-invariant");
        return properties;
    }

    public static Set<String> getV1SyntaxProperties() {
        HashSet<String> properties = new HashSet<String>();
        properties.add("state-labels");
        properties.add("trans-labels");
        properties.add("implicit-labels");
        properties.add("explicit-labels");
        properties.add("state-acc");
        properties.add("trans-acc");
        return properties;
    }

    public static Set<String> getV1BranchingProperties() {
        HashSet<String> properties = new HashSet<String>();
        properties.add("univ-branch");
        properties.add("no-univ-branch");
        properties.add("deterministic");
        properties.add("complete");
        return properties;
    }

    public static Set<String> getV1StructuralProperties() {
        HashSet<String> properties = new HashSet<String>();
        properties.add("unambiguous");
        properties.add("weak");
        properties.add("very-weak");
        properties.add("inherently-weak");
        properties.add("terminal");
        properties.add("tight");
        return properties;
    }
}

