/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.visitors;

import java.util.Set;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.SyntacticFragment;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.visitors.Converter;

public class UnabbreviateVisitor
extends Converter {
    private final Set<Class<? extends Formula>> classes;

    @SafeVarargs
    public UnabbreviateVisitor(Class<? extends Formula> ... classes) {
        super(SyntacticFragment.NNF);
        this.classes = Set.of(classes);
    }

    @Override
    public Formula visit(ROperator rOperator) {
        if (!this.classes.contains(ROperator.class)) {
            return super.visit(rOperator);
        }
        Formula left = rOperator.left.accept(this);
        Formula right = rOperator.right.accept(this);
        return Disjunction.of(GOperator.of(right), UOperator.of(right, Conjunction.of(left, right)));
    }

    @Override
    public Formula visit(WOperator wOperator) {
        if (!this.classes.contains(WOperator.class)) {
            return super.visit(wOperator);
        }
        Formula left = wOperator.left.accept(this);
        Formula right = wOperator.right.accept(this);
        return Disjunction.of(GOperator.of(left), UOperator.of(left, right));
    }

    @Override
    public Formula visit(MOperator mOperator) {
        if (!this.classes.contains(MOperator.class)) {
            return super.visit(mOperator);
        }
        Formula left = mOperator.left.accept(this);
        Formula right = mOperator.right.accept(this);
        return UOperator.of(right, Conjunction.of(left, right));
    }
}

