/*
 * Decompiled with CFR 0.152.
 */
package owl.run.parser;

import com.google.common.base.Preconditions;
import java.util.List;
import org.immutables.value.Value;
import owl.run.modules.InputReader;
import owl.run.modules.OutputWriter;
import owl.run.modules.OwlModuleParser;
import owl.run.modules.Transformer;
import owl.run.parser.PartialModuleConfigurationBuilder;
import owl.run.parser.Wrapper;

@Value.Immutable
@Value.Style(visibility=Value.Style.ImplementationVisibility.PRIVATE, builderVisibility=Value.Style.BuilderVisibility.PACKAGE)
public abstract class PartialModuleConfiguration {
    public static Constructor builder(String name) {
        return new Constructor(name);
    }

    abstract Wrapper input();

    abstract List<Wrapper> transformers();

    abstract Wrapper output();

    abstract String name();

    public static final class Constructor {
        private final PartialModuleConfigurationBuilder builder;

        Constructor(String name) {
            this.builder = new PartialModuleConfigurationBuilder().name(name);
        }

        public Constructor reader(InputReader reader) {
            this.builder.input(Wrapper.module(reader));
            return this;
        }

        public Constructor addTransformer(OwlModuleParser.TransformerParser ... settings) {
            Preconditions.checkNotNull((Object)settings);
            for (OwlModuleParser.TransformerParser setting : settings) {
                this.builder.addTransformers(Wrapper.settings(setting));
            }
            return this;
        }

        public Constructor addTransformer(Transformer ... transformers) {
            Preconditions.checkNotNull((Object)transformers);
            for (Transformer transformer : transformers) {
                this.builder.addTransformers(Wrapper.module(transformer));
            }
            return this;
        }

        public Constructor reader(OwlModuleParser.ReaderParser settings) {
            this.builder.input(Wrapper.settings(settings));
            return this;
        }

        public Constructor writer(OutputWriter writer) {
            this.builder.output(Wrapper.module(writer));
            return this;
        }

        public Constructor writer(OwlModuleParser.WriterParser settings) {
            this.builder.output(Wrapper.settings(settings));
            return this;
        }

        public PartialModuleConfiguration build() {
            return this.builder.build();
        }
    }
}

