/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dpa;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.factories.EquivalenceClassFactory;
import owl.ltl.EquivalenceClass;
import owl.translations.SafetyCoreDetector;
import owl.translations.ltl2dpa.SymmetricRankingState;
import owl.translations.ltl2ldba.AnnotatedLDBA;
import owl.translations.ltl2ldba.SymmetricProductState;
import owl.translations.mastertheorem.SymmetricEvaluatedFixpoints;

final class SymmetricDPAConstruction {
    private SymmetricDPAConstruction() {
    }

    static Automaton<SymmetricRankingState, ParityAcceptance> of(AnnotatedLDBA<Map<Integer, EquivalenceClass>, SymmetricProductState, BuchiAcceptance, SortedSet<SymmetricEvaluatedFixpoints>, BiFunction<Integer, EquivalenceClass, Set<SymmetricProductState>>> ldba) {
        Builder builder = new Builder(ldba);
        return AutomatonFactory.create(builder.ldba.factory(), builder.initialState, builder.acceptance, builder::edge);
    }

    static final class Builder {
        final ParityAcceptance acceptance;
        final SymmetricRankingState initialState;
        final EquivalenceClassFactory factory;
        final List<Set<Map<Integer, EquivalenceClass>>> initialComponentSccs;
        final AnnotatedLDBA<Map<Integer, EquivalenceClass>, SymmetricProductState, BuchiAcceptance, SortedSet<SymmetricEvaluatedFixpoints>, BiFunction<Integer, EquivalenceClass, Set<SymmetricProductState>>> ldba;

        private Builder(AnnotatedLDBA<Map<Integer, EquivalenceClass>, SymmetricProductState, BuchiAcceptance, SortedSet<SymmetricEvaluatedFixpoints>, BiFunction<Integer, EquivalenceClass, Set<SymmetricProductState>>> ldba) {
            this.ldba = ldba;
            this.initialComponentSccs = SccDecomposition.computeSccs(ldba.initialComponent());
            this.acceptance = new ParityAcceptance(2 * Math.max(1, ldba.acceptingComponent().size() + 1), ParityAcceptance.Parity.MIN_ODD);
            Map<Integer, EquivalenceClass> ldbaInitialState = ldba.initialComponent().onlyInitialState();
            this.factory = ldbaInitialState.entrySet().iterator().next().getValue().factory();
            this.initialState = this.edge(ldbaInitialState, List.of(), 0, -1, null).successor();
        }

        Edge<SymmetricRankingState> edge(Map<Integer, EquivalenceClass> successor, List<SymmetricProductState> previousRanking, int previousSafetyBucket, int previousSafetyBucketIndex, @Nullable BitSet valuation) {
            int safetyBucketIndex;
            int safetyBucket;
            for (EquivalenceClass clazz : successor.values()) {
                if (!SafetyCoreDetector.safetyCoreExists(clazz)) continue;
                return Edge.of(SymmetricRankingState.of(successor), 1);
            }
            HashSet allowedComponents = new HashSet();
            List targets = List.of(new ArrayList(), new ArrayList(), new ArrayList());
            TreeMap safety = new TreeMap();
            successor.forEach((index, value) -> {
                for (SymmetricProductState jumpTarget : this.ldba.stateAnnotation().apply((Integer)index, (EquivalenceClass)value)) {
                    if (!this.ldba.acceptingComponent().states().contains(jumpTarget)) continue;
                    SymmetricEvaluatedFixpoints fixpoints = jumpTarget.evaluatedFixpoints;
                    boolean changed = allowedComponents.add(fixpoints);
                    if (fixpoints.isSafety()) {
                        safety.compute((Integer)index, (x, oldList) -> {
                            if (oldList == null) {
                                return new ArrayList<SymmetricProductState>(List.of(jumpTarget));
                            }
                            oldList.add(jumpTarget);
                            return oldList;
                        });
                        continue;
                    }
                    if (fixpoints.isLiveness() && jumpTarget.safety.isTrue()) {
                        assert (changed);
                        ((List)targets.get(0)).add(jumpTarget);
                        continue;
                    }
                    if (fixpoints.isLiveness()) {
                        assert (changed);
                        ((List)targets.get(1)).add(jumpTarget);
                        continue;
                    }
                    assert (changed);
                    ((List)targets.get(2)).add(jumpTarget);
                }
            });
            targets.forEach(x -> x.sort(Comparator.comparing(y -> y.evaluatedFixpoints)));
            safety.values().forEach(x -> x.sort(Comparator.comparing(y -> y.evaluatedFixpoints)));
            int edgeColor = 2 * previousRanking.size();
            ArrayList<SymmetricProductState> ranking = new ArrayList<SymmetricProductState>(previousRanking.size());
            boolean activeSafetyComponent = false;
            ListIterator<SymmetricProductState> iterator = previousRanking.listIterator();
            while (iterator.hasNext()) {
                Object rankingSuccessor;
                assert (valuation != null) : "Valuation is only allowed to be null for empty rankings.";
                Edge<SymmetricProductState> rankingEdge = this.ldba.acceptingComponent().edge(iterator.next(), valuation);
                Object object = rankingSuccessor = rankingEdge == null ? null : rankingEdge.successor();
                if (rankingEdge == null || !allowedComponents.remove(((SymmetricProductState)rankingSuccessor).evaluatedFixpoints)) {
                    edgeColor = Math.min(2 * iterator.previousIndex(), edgeColor);
                    continue;
                }
                ranking.add((SymmetricProductState)rankingSuccessor);
                if (rankingEdge.inSet(0)) {
                    edgeColor = Math.min(2 * iterator.previousIndex() + 1, edgeColor);
                }
                if (!((SymmetricProductState)rankingSuccessor).evaluatedFixpoints.isSafety()) continue;
                assert (rankingEdge.inSet(0)) : "SafetyComponents are assumed to be always accepting.";
                activeSafetyComponent = true;
            }
            if (activeSafetyComponent) {
                safetyBucket = previousSafetyBucket;
                safetyBucketIndex = previousSafetyBucketIndex;
            } else {
                for (SymmetricProductState rankingState : Iterables.concat((Iterable)targets.get(0), (Iterable)targets.get(1), (Iterable)targets.get(2))) {
                    if (!allowedComponents.remove(rankingState.evaluatedFixpoints)) continue;
                    ranking.add(rankingState);
                }
                Map.Entry safetyEntry = safety.ceilingEntry(previousSafetyBucket);
                safetyBucketIndex = previousSafetyBucketIndex;
                if (safetyEntry != null) {
                    if (safetyEntry.getKey() == previousSafetyBucket && ((List)safetyEntry.getValue()).size() <= safetyBucketIndex + 1) {
                        safetyEntry = safety.ceilingEntry(previousSafetyBucket + 1);
                        safetyBucketIndex = -1;
                    } else if (safetyEntry.getKey() > previousSafetyBucket) {
                        safetyBucketIndex = -1;
                    }
                }
                if (safetyEntry == null) {
                    safetyEntry = safety.ceilingEntry(0);
                    safetyBucketIndex = -1;
                }
                if (safetyEntry == null) {
                    safetyBucket = 0;
                    safetyBucketIndex = -1;
                } else {
                    safetyBucket = safetyEntry.getKey();
                    assert (safetyBucket > 0);
                    ranking.add((SymmetricProductState)((List)safetyEntry.getValue()).get(++safetyBucketIndex));
                }
            }
            assert (edgeColor < this.acceptance.acceptanceSets());
            return Edge.of(SymmetricRankingState.of(successor, ranking, safetyBucket, safetyBucketIndex), edgeColor);
        }

        @Nullable
        Edge<SymmetricRankingState> edge(SymmetricRankingState state, BitSet valuation) {
            Map<Integer, EquivalenceClass> successor = this.ldba.initialComponent().successor((Map<Integer, EquivalenceClass>)state.state(), valuation);
            if (successor == null) {
                return null;
            }
            if (this.initialComponentSccs.stream().anyMatch(x -> x.contains(state.state()) && !x.contains(successor))) {
                return this.edge(successor, List.of(), 0, -1, valuation).withoutAcceptance();
            }
            return this.edge(successor, state.ranking(), state.safetyBucket(), state.safetyBucketIndex(), valuation);
        }
    }
}

