/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.mastertheorem;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;
import owl.ltl.Formula;
import owl.translations.mastertheorem.Fixpoints;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Fixpoints", generator="Immutables")
@Immutable
final class FixpointsTuple
extends Fixpoints {
    private final ImmutableSet<Formula.ModalOperator> leastFixpoints;
    private final ImmutableSet<Formula.ModalOperator> greatestFixpoints;
    private final transient int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long FIXPOINTS_LAZY_INIT_BIT = 1L;
    private transient Set<Formula.ModalOperator> fixpoints;
    private static final long SIMPLIFIED_LAZY_INIT_BIT = 2L;
    private transient Fixpoints simplified;

    private FixpointsTuple(Iterable<? extends Formula.ModalOperator> leastFixpoints, Iterable<? extends Formula.ModalOperator> greatestFixpoints) {
        this.leastFixpoints = ImmutableSet.copyOf(leastFixpoints);
        this.greatestFixpoints = ImmutableSet.copyOf(greatestFixpoints);
        this.hashCode = this.computeHashCode();
    }

    public ImmutableSet<Formula.ModalOperator> leastFixpoints() {
        return this.leastFixpoints;
    }

    public ImmutableSet<Formula.ModalOperator> greatestFixpoints() {
        return this.greatestFixpoints;
    }

    @Override
    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof FixpointsTuple && this.equalTo((FixpointsTuple)another);
    }

    private boolean equalTo(FixpointsTuple another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.leastFixpoints.equals(another.leastFixpoints) && this.greatestFixpoints.equals(another.greatestFixpoints);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.leastFixpoints.hashCode();
        h += (h << 5) + this.greatestFixpoints.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Fixpoints").omitNullValues().add("leastFixpoints", this.leastFixpoints).add("greatestFixpoints", this.greatestFixpoints).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Formula.ModalOperator> fixpoints() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            FixpointsTuple fixpointsTuple = this;
            synchronized (fixpointsTuple) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.fixpoints = Objects.requireNonNull(super.fixpoints(), "fixpoints");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.fixpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Fixpoints simplified() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            FixpointsTuple fixpointsTuple = this;
            synchronized (fixpointsTuple) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.simplified = Objects.requireNonNull(super.simplified(), "simplified");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.simplified;
    }

    public static FixpointsTuple create(Set<Formula.ModalOperator> leastFixpoints, Set<Formula.ModalOperator> greatestFixpoints) {
        return FixpointsTuple.create(leastFixpoints, greatestFixpoints);
    }

    public static FixpointsTuple create(Iterable<? extends Formula.ModalOperator> leastFixpoints, Iterable<? extends Formula.ModalOperator> greatestFixpoints) {
        return FixpointsTuple.validate(new FixpointsTuple(leastFixpoints, greatestFixpoints));
    }

    private static FixpointsTuple validate(FixpointsTuple instance) {
        instance.check();
        return instance;
    }
}

