/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nba2ldba;

import com.google.common.collect.Sets;
import de.tum.in.naturals.bitset.BitSets;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import owl.automaton.Automaton;
import owl.automaton.AutomatonUtil;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.TwoPartAutomaton;
import owl.automaton.Views;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.optimizations.AcceptanceOptimizations;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.automaton.edge.Edges;
import owl.collections.Either;
import owl.collections.ValuationSet;
import owl.collections.ValuationTree;
import owl.factories.ValuationSetFactory;
import owl.run.modules.ImmutableTransformerParser;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.OwlModuleParser;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.nba2ldba.BreakpointState;
import owl.translations.nba2ldba.LDBATuple;
import owl.util.annotation.HashedTuple;

public final class NBA2LDBA
implements Function<Automaton<?, ?>, Automaton<?, BuchiAcceptance>> {
    public static final OwlModuleParser.TransformerParser CLI = ImmutableTransformerParser.builder().key("nba2ldba").description("Converts a non-deterministic B\u00fcchi automaton into a limit-deterministic B\u00fcchi automaton").parser(settings -> environment -> (input, context) -> new NBA2LDBA().apply(AutomatonUtil.cast(input))).build();

    @Override
    public Automaton<?, BuchiAcceptance> apply(Automaton<?, ?> automaton) {
        return NBA2LDBA.applyLDBA(automaton).automaton();
    }

    public static LDBA<?> applyLDBA(Automaton<?, ?> automaton) {
        Automaton<Object, BuchiAcceptance> nba;
        Optional<Set<Object>> initialComponentOptional;
        Automaton<Object, GeneralizedBuchiAcceptance> ngba;
        if (automaton.acceptance() instanceof AllAcceptance) {
            Automaton<Set<?>, AllAcceptance> allAutomaton = Views.createPowerSetAutomaton(automaton, AllAcceptance.INSTANCE, true);
            Automaton<Object, AllAcceptance> castedAutomaton = AutomatonUtil.cast(allAutomaton, Object.class, AllAcceptance.class);
            ngba = Views.viewAs(castedAutomaton, GeneralizedBuchiAcceptance.class);
        } else if (automaton.acceptance() instanceof GeneralizedBuchiAcceptance) {
            ngba = AutomatonUtil.cast(automaton, Object.class, GeneralizedBuchiAcceptance.class);
        } else {
            throw new UnsupportedOperationException(automaton.acceptance() + " is unsupported.");
        }
        if (automaton.acceptance() instanceof BuchiAcceptance && (initialComponentOptional = AutomatonUtil.ldbaSplit(nba = AutomatonUtil.cast(ngba, BuchiAcceptance.class))).isPresent()) {
            return LDBA.of(nba, initialComponentOptional.orElseThrow());
        }
        MutableAutomaton ldba = MutableAutomatonUtil.asMutable(new BreakpointAutomaton<Object>(ngba));
        AcceptanceOptimizations.removeDeadStates(ldba);
        return LDBA.of(ldba, ldba.states().stream().filter(Either::isLeft).collect(Collectors.toSet()));
    }

    public static void main(String ... args) {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.builder("nba2ldba").reader(InputReaders.HOA).addTransformer(CLI).writer(OutputWriters.HOA).build());
    }

    static final class BreakpointAutomaton<S>
    extends TwoPartAutomaton<S, BreakpointState<S>, BuchiAcceptance> {
        private final Automaton<S, GeneralizedBuchiAcceptance> ngba;
        private final List<Set<S>> sccs;
        private final int acceptanceSets;

        BreakpointAutomaton(Automaton<S, GeneralizedBuchiAcceptance> ngba) {
            this.ngba = ngba;
            this.sccs = SccDecomposition.computeSccs(ngba, false);
            this.acceptanceSets = Math.max(ngba.acceptance().acceptanceSets(), 1);
        }

        @Override
        protected Set<S> initialStatesA() {
            return this.ngba.initialStates();
        }

        @Override
        protected Set<BreakpointState<S>> initialStatesB() {
            return Set.of();
        }

        @Override
        protected ValuationTree<Edge<S>> edgeTreeA(S state) {
            return this.ngba.edgeTree(state).map(x -> x.stream().map(Edge::withoutAcceptance).collect(Collectors.toUnmodifiableSet()));
        }

        @Override
        protected ValuationTree<Edge<BreakpointState<S>>> edgeTreeB(BreakpointState<S> state) {
            ValuationSetFactory factory = this.factory();
            HashMap<Edge<BreakpointState<S>>, ValuationSet> labelledEdges = new HashMap<Edge<BreakpointState<S>>, ValuationSet>();
            for (BitSet valuation : BitSets.powerSet((int)factory.alphabetSize())) {
                for (Edge<BreakpointState<S>> edge : this.edgesB(state, valuation)) {
                    labelledEdges.merge(edge, factory.of(valuation), ValuationSet::union);
                }
            }
            return factory.inverse(labelledEdges);
        }

        @Override
        protected Set<Edge<BreakpointState<S>>> edgesB(BreakpointState<S> ldbaState, BitSet valuation) {
            Set n1;
            int i1;
            Optional<Set> optionalScc = this.sccs.stream().filter(x -> x.containsAll(ldbaState.mx())).findAny();
            if (!optionalScc.isPresent()) {
                return Set.of();
            }
            Set scc = optionalScc.get();
            Set outEdgesM = ldbaState.mx().stream().flatMap(x -> this.ngba.edges(x, valuation).stream()).filter(x -> scc.contains(x.successor())).collect(Collectors.toSet());
            if (outEdgesM.isEmpty()) {
                return Set.of();
            }
            Set outEdgesN = ldbaState.nx().stream().flatMap(x -> this.ngba.edges(x, valuation).stream()).filter(x -> scc.contains(x.successor())).collect(Collectors.toSet());
            Set intersection = outEdgesM.stream().filter(x -> x.inSet(ldbaState.ix() % this.acceptanceSets)).collect(Collectors.toSet());
            outEdgesN.addAll(intersection);
            if (outEdgesM.equals(outEdgesN)) {
                i1 = (ldbaState.ix() + 1) % this.acceptanceSets;
                n1 = Edges.successors(Sets.filter(outEdgesM, x -> x.inSet(i1)));
            } else {
                i1 = ldbaState.ix();
                n1 = Edges.successors(outEdgesN);
            }
            BreakpointState successor = BreakpointState.of(i1, Edges.successors(outEdgesM), n1);
            return Set.of(i1 == 0 && outEdgesM.equals(outEdgesN) ? Edge.of(successor, 0) : Edge.of(successor));
        }

        @Override
        protected Set<BreakpointState<S>> moveAtoB(S state) {
            for (Set<S> scc : this.sccs) {
                if (!scc.contains(state)) continue;
                return Set.of(BreakpointState.of(0, Set.of(state), Set.of()));
            }
            return Set.of();
        }

        @Override
        public BuchiAcceptance acceptance() {
            return BuchiAcceptance.INSTANCE;
        }

        @Override
        public ValuationSetFactory factory() {
            return this.ngba.factory();
        }
    }

    @Value.Immutable
    @HashedTuple
    public static abstract class LDBA<S> {
        public abstract Automaton<S, BuchiAcceptance> automaton();

        public abstract Set<S> initialComponent();

        static <S> LDBA<S> of(Automaton<S, BuchiAcceptance> automaton, Set<S> initialComponent) {
            return LDBATuple.create(automaton, initialComponent);
        }
    }
}

