/*
 * Decompiled with CFR 0.152.
 */
package owl.cinterface;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.util.AnnotatedState;
import owl.cinterface.Acceptance;
import owl.collections.Either;
import owl.collections.ValuationTree;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.ltl.XOperator;
import owl.run.DefaultEnvironment;
import owl.run.Environment;
import owl.translations.LTL2DAFunction;
import owl.translations.canonical.BreakpointState;
import owl.translations.canonical.GenericConstructions;
import owl.translations.canonical.RoundRobinState;
import owl.translations.ltl2dpa.LTL2DPAFunction;
import owl.util.annotation.CEntryPoint;

public final class DeterministicAutomaton<S, T> {
    public static final int ACCEPTING = -2;
    public static final int REJECTING = -1;
    private static final int UNKNOWN = Integer.MIN_VALUE;
    private static final Environment ENV = DefaultEnvironment.standard();
    private final Acceptance acceptance;
    private final Predicate<S> acceptingSink;
    private final Automaton<S, ?> automaton;
    private final List<S> index2StateMap;
    private final Object2IntMap<S> state2indexMap;
    private final ToDoubleFunction<Edge<S>> qualityScore;
    private final Function<S, T> canonicalizer;
    private final Object2IntMap<T> canonicalObjectId;

    private <A extends OmegaAcceptance> DeterministicAutomaton(Automaton<S, A> automaton, Acceptance acceptance, Class<A> acceptanceClassBound, Predicate<S> acceptingSink, Function<S, T> canonicalizer, ToDoubleFunction<Edge<S>> qualityScore) {
        Preconditions.checkArgument((automaton.initialStates().size() == 1 ? 1 : 0) != 0);
        this.automaton = automaton;
        this.acceptance = acceptance;
        this.acceptingSink = acceptingSink;
        this.qualityScore = qualityScore;
        this.index2StateMap = new ArrayList<S>();
        this.index2StateMap.add(this.automaton.onlyInitialState());
        this.state2indexMap = new Object2IntOpenHashMap();
        this.state2indexMap.put(this.automaton.onlyInitialState(), 0);
        this.state2indexMap.defaultReturnValue(Integer.MIN_VALUE);
        this.canonicalObjectId = new Object2IntOpenHashMap();
        this.canonicalObjectId.defaultReturnValue(Integer.MIN_VALUE);
        this.canonicalizer = canonicalizer;
    }

    public static DeterministicAutomaton<?, ?> of(LabelledFormula formula) {
        LTL2DPAFunction function;
        Automaton<?, ParityAcceptance> automaton;
        Set<Formula> formulasDisj;
        Set<Formula> formulasConj;
        if (SyntacticFragment.SAFETY.contains(formula)) {
            return new DeterministicAutomaton(LTL2DAFunction.safety(ENV, formula), Acceptance.SAFETY, AllAcceptance.class, EquivalenceClass::isTrue, Function.identity(), edge -> ((EquivalenceClass)edge.successor()).trueness());
        }
        if (SyntacticFragment.CO_SAFETY.contains(formula)) {
            return new DeterministicAutomaton(LTL2DAFunction.coSafety(ENV, formula), Acceptance.CO_SAFETY, BuchiAcceptance.class, EquivalenceClass::isTrue, Function.identity(), edge -> ((EquivalenceClass)edge.successor()).trueness());
        }
        Set<Formula> set = formulasConj = formula.formula() instanceof Conjunction ? formula.formula().children() : Set.of(formula.formula());
        if (formulasConj.stream().allMatch(SyntacticFragments::isGfCoSafety)) {
            return new DeterministicAutomaton<RoundRobinState, LabelledFormula>(LTL2DAFunction.gfCoSafety(ENV, formula, false), Acceptance.BUCHI, GeneralizedBuchiAcceptance.class, x -> false, x -> formula, x -> x.inSet(0) ? 1.0 : 0.5);
        }
        if (SyntacticFragments.isGCoSafety(formula.formula())) {
            return new DeterministicAutomaton<BreakpointState, EquivalenceClass>(LTL2DAFunction.gCoSafety(ENV, formula), Acceptance.BUCHI, BuchiAcceptance.class, x -> false, x -> ((EquivalenceClass)x.current()).and((EquivalenceClass)x.next()), x -> x.inSet(0) ? 1.0 : 0.5);
        }
        if (formula.formula() instanceof XOperator) {
            int xCount = 0;
            Formula unwrapped = formula.formula();
            while (unwrapped instanceof XOperator) {
                ++xCount;
                unwrapped = ((XOperator)unwrapped).operand;
            }
            if (SyntacticFragments.isGCoSafety(unwrapped)) {
                return new DeterministicAutomaton<Either, Object>(GenericConstructions.delay(LTL2DAFunction.gCoSafety(ENV, LabelledFormula.of(unwrapped, formula.variables())), xCount), Acceptance.BUCHI, BuchiAcceptance.class, x -> false, x -> x.either(i -> i, j -> ((EquivalenceClass)j.current()).and((EquivalenceClass)j.next())), x -> x.inSet(0) ? 1.0 : 0.5);
            }
        }
        Set<Formula> set2 = formulasDisj = formula.formula() instanceof Disjunction ? formula.formula().children() : Set.of(formula.formula());
        if (formulasDisj.stream().allMatch(SyntacticFragments::isFgSafety)) {
            return new DeterministicAutomaton<RoundRobinState, LabelledFormula>(LTL2DAFunction.fgSafetyInterleaved(ENV, formula), Acceptance.CO_BUCHI, CoBuchiAcceptance.class, x -> false, x -> formula, x -> x.inSet(0) ? 0.0 : 0.5);
        }
        if (SyntacticFragments.isFSafety(formula.formula())) {
            return new DeterministicAutomaton<BreakpointState, EquivalenceClass>(LTL2DAFunction.fSafety(ENV, formula), Acceptance.CO_BUCHI, CoBuchiAcceptance.class, x -> false, x -> ((EquivalenceClass)x.current()).and((EquivalenceClass)x.next()), x -> x.inSet(0) ? 0.0 : 0.5);
        }
        if (formula.formula() instanceof XOperator) {
            int xCount = 0;
            Formula unwrappedFormula = formula.formula();
            while (unwrappedFormula instanceof XOperator) {
                ++xCount;
                unwrappedFormula = ((XOperator)unwrappedFormula).operand;
            }
            if (SyntacticFragments.isFSafety(unwrappedFormula)) {
                return new DeterministicAutomaton<Either, Object>(GenericConstructions.delay(LTL2DAFunction.fSafety(ENV, formula.wrap(unwrappedFormula)), xCount), Acceptance.CO_BUCHI, CoBuchiAcceptance.class, x -> false, x -> x.either(i -> i, j -> ((EquivalenceClass)j.current()).and((EquivalenceClass)j.next())), x -> x.inSet(0) ? 0.0 : 0.5);
            }
        }
        if ((automaton = (function = new LTL2DPAFunction(ENV, EnumSet.of(LTL2DPAFunction.Configuration.COMPLEMENT_CONSTRUCTION_HEURISTIC))).apply(formula)).acceptance().parity() == ParityAcceptance.Parity.MIN_ODD) {
            return new DeterministicAutomaton<AnnotatedState, EquivalenceClass>(automaton, Acceptance.PARITY_MIN_ODD, ParityAcceptance.class, x -> ((EquivalenceClass)x.state()).isTrue(), AnnotatedState::state, x -> ((EquivalenceClass)((AnnotatedState)x.successor()).state()).trueness());
        }
        assert (automaton.acceptance().parity() == ParityAcceptance.Parity.MIN_EVEN);
        return new DeterministicAutomaton<AnnotatedState, EquivalenceClass>(automaton, Acceptance.PARITY_MIN_EVEN, ParityAcceptance.class, x -> ((EquivalenceClass)x.state()).isFalse(), AnnotatedState::state, x -> 1.0 - ((EquivalenceClass)((AnnotatedState)x.successor()).state()).trueness());
    }

    @CEntryPoint
    public int acceptance() {
        return this.acceptance.ordinal();
    }

    @CEntryPoint
    public int acceptanceSetCount() {
        return ((OmegaAcceptance)this.automaton.acceptance()).acceptanceSets();
    }

    @CEntryPoint
    public int[] edges(int stateIndex) {
        S state = this.index2StateMap.get(stateIndex);
        IntArrayList nodes = new IntArrayList();
        IntArrayList leaves = new IntArrayList();
        nodes.add(-1);
        this.serialise(this.automaton.edgeTree(state), new HashMap<ValuationTree<Edge<S>>, Integer>(), nodes, leaves);
        nodes.set(0, nodes.size());
        nodes.addAll((IntList)leaves);
        return nodes.toIntArray();
    }

    @CEntryPoint
    public double qualityScore(int successorIndex, int colour) {
        S successor = this.index2StateMap.get(successorIndex);
        Edge<S> edge = colour >= 0 ? Edge.of(successor, colour) : Edge.of(successor);
        return this.qualityScore.applyAsDouble(edge);
    }

    int size() {
        return this.automaton.size();
    }

    int normalise(int stateIndex) {
        if (stateIndex == -2) {
            return -2;
        }
        if (stateIndex == -1) {
            return -1;
        }
        T canonicalObject = this.canonicalizer.apply(this.index2StateMap.get(stateIndex));
        return this.canonicalObjectId.computeIntIfAbsent(canonicalObject, x -> this.canonicalObjectId.size());
    }

    private int index(@Nullable S state) {
        if (state == null) {
            return -1;
        }
        if (this.acceptingSink.test(state)) {
            return -2;
        }
        int index = this.state2indexMap.getInt(state);
        if (index == Integer.MIN_VALUE) {
            this.index2StateMap.add(state);
            this.state2indexMap.put(state, this.index2StateMap.size() - 1);
            index = this.index2StateMap.size() - 1;
        }
        return index;
    }

    private int serialise(ValuationTree<Edge<S>> tree, Map<ValuationTree<Edge<S>>, Integer> cache, IntArrayList nodes, IntArrayList leaves) {
        int index = cache.getOrDefault(tree, Integer.MIN_VALUE);
        if (index != Integer.MIN_VALUE) {
            return index;
        }
        if (tree instanceof ValuationTree.Node) {
            ValuationTree.Node node = (ValuationTree.Node)tree;
            index = nodes.size();
            nodes.add(node.variable);
            nodes.add(-1);
            nodes.add(-1);
            nodes.set(index + 1, this.serialise(node.falseChild, cache, nodes, leaves));
            nodes.set(index + 2, this.serialise(node.trueChild, cache, nodes, leaves));
        } else {
            Edge edge = (Edge)Iterables.getOnlyElement(((ValuationTree.Leaf)tree).value, null);
            index = -leaves.size();
            leaves.add(edge == null ? -1 : this.index(edge.successor()));
            leaves.add(edge == null ? -1 : edge.largestAcceptanceSet());
        }
        cache.put(tree, index);
        return index;
    }
}

