/*
 * Decompiled with CFR 0.152.
 */
package owl.translations;

import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;

public final class SafetyCoreDetector {
    private SafetyCoreDetector() {
    }

    public static boolean safetyCoreExists(EquivalenceClass state) {
        Set<Formula.ModalOperator> modalOperators = state.modalOperators();
        if (SyntacticFragments.isSafety(modalOperators)) {
            return true;
        }
        Set nonSafetyModalOperators = modalOperators.stream().filter(Predicate.not(SyntacticFragment.SAFETY::contains)).collect(Collectors.toSet());
        EquivalenceClass safetyCore = state.substitute(x -> nonSafetyModalOperators.stream().anyMatch(y -> y.anyMatch(x::equals)) ? BooleanConstant.FALSE : x);
        return !safetyCore.isFalse() && !safetyCore.atomicPropositions().intersects(Conjunction.of(nonSafetyModalOperators).atomicPropositions(true));
    }
}

