/*
 * Decompiled with CFR 0.152.
 */
package owl.run;

import com.google.common.base.Strings;
import java.util.concurrent.Callable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import owl.run.DefaultEnvironment;
import owl.run.Pipeline;
import owl.run.RunUtil;
import owl.run.ServerRunner;
import owl.run.modules.OwlModuleRegistry;
import owl.run.parser.OwlParser;

public final class ServerCli {
    private ServerCli() {
    }

    public static Options getOptions() {
        Option portOption = new Option(null, "port", true, "Port to listen on (default 5050)");
        return new Options().addOption(portOption).addOption(RunUtil.getDefaultAnnotationOption());
    }

    public static Callable<Void> build(CommandLine settings, Pipeline pipeline) {
        int port;
        if (Strings.isNullOrEmpty((String)settings.getOptionValue("port"))) {
            port = 5050;
        } else {
            try {
                port = Integer.parseInt(settings.getOptionValue("port"));
            }
            catch (NumberFormatException e) {
                throw RunUtil.failWithMessage("Invalid value for port", e);
            }
        }
        boolean annotations = RunUtil.checkDefaultAnnotationOption(settings);
        return new ServerRunner(pipeline, () -> DefaultEnvironment.of(annotations), port);
    }

    public static void main(String ... args) {
        OwlParser parseResult = OwlParser.parse(args, (CommandLineParser)new DefaultParser(), ServerCli.getOptions(), OwlModuleRegistry.DEFAULT_REGISTRY);
        if (parseResult == null) {
            System.exit(1);
            return;
        }
        RunUtil.execute(ServerCli.build(parseResult.globalSettings, parseResult.pipeline));
    }
}

