/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import de.tum.in.naturals.set.NatBitSet;
import de.tum.in.naturals.set.NatBitSets;
import de.tum.in.naturals.set.NatBitSetsUtil;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.NoSuchElementException;

public abstract class AbstractNatBitSet
extends AbstractIntSet
implements NatBitSet {
    @Override
    public boolean add(int index) {
        if (this.contains(index)) {
            return false;
        }
        this.set(index);
        return true;
    }

    @Override
    public void and(IntCollection indices) {
        if (indices.isEmpty()) {
            this.clear();
        } else {
            IntIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                int next = iterator.nextInt();
                if (indices.contains(next)) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public void andNot(IntCollection indices) {
        if (indices.isEmpty()) {
            return;
        }
        IntIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            int next = iterator.nextInt();
            if (!indices.contains(next)) continue;
            iterator.remove();
        }
    }

    @Override
    public void clearFrom(int from) {
        NatBitSetsUtil.checkNonNegative(from);
        this.clear(from, Integer.MAX_VALUE);
    }

    @Override
    public AbstractNatBitSet clone() {
        try {
            return (AbstractNatBitSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public int firstInt() {
        int firstPresent = this.nextPresentIndex(0);
        if (firstPresent == -1) {
            throw new NoSuchElementException();
        }
        return firstPresent;
    }

    @Override
    public boolean intersects(IntCollection indices) {
        return IntIterators.any((IntIterator)indices.iterator(), arg_0 -> ((AbstractNatBitSet)this).contains(arg_0));
    }

    @Override
    public void or(IntCollection indices) {
        if (indices.isEmpty()) {
            return;
        }
        indices.forEach(this::set);
    }

    @Override
    public boolean remove(int index) {
        if (!this.contains(index)) {
            return false;
        }
        this.clear(index);
        return true;
    }

    public boolean removeAll(IntCollection indices) {
        if (!this.intersects(indices)) {
            return false;
        }
        this.andNot(indices);
        return true;
    }

    public boolean retainAll(IntCollection indices) {
        if (IntIterators.all((IntIterator)this.iterator(), arg_0 -> ((IntCollection)indices).contains(arg_0))) {
            return false;
        }
        this.and(indices);
        return true;
    }

    @Override
    public void xor(IntCollection indices) {
        if (indices.isEmpty()) {
            return;
        }
        IntSet set = indices instanceof IntSet ? (IntSet)indices : NatBitSets.copyOf(indices);
        set.forEach(this::flip);
    }
}

