/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.ast;

import java.util.BitSet;
import jhoafparser.ast.Atom;
import jhoafparser.ast.AtomLabel;

public class BooleanExpression<Atoms extends Atom> {
    private Type type;
    private BooleanExpression<Atoms> left = null;
    private BooleanExpression<Atoms> right = null;
    private Atoms atom = null;

    public BooleanExpression(Type type, BooleanExpression<Atoms> left, BooleanExpression<Atoms> right) {
        this.type = type;
        this.left = left;
        this.right = right;
        this.atom = null;
    }

    public BooleanExpression(boolean value) {
        this.type = value ? Type.EXP_TRUE : Type.EXP_FALSE;
        this.left = null;
        this.right = null;
        this.atom = null;
    }

    public BooleanExpression(Atoms atom) {
        this.type = Type.EXP_ATOM;
        this.left = null;
        this.right = null;
        this.atom = atom;
    }

    public Type getType() {
        return this.type;
    }

    public BooleanExpression<Atoms> getLeft() {
        return this.left;
    }

    public BooleanExpression<Atoms> getRight() {
        return this.right;
    }

    public Atoms getAtom() {
        return this.atom;
    }

    public BooleanExpression<Atoms> clone() {
        if (this.isAtom()) {
            return new BooleanExpression<Atom>(this.atom.clone());
        }
        Object newLeft = this.left != null ? this.left.clone() : null;
        Object newRight = this.right != null ? this.right.clone() : null;
        return new BooleanExpression<Atoms>(this.type, newLeft, newRight);
    }

    public boolean isAND() {
        return this.type == Type.EXP_AND;
    }

    public boolean isOR() {
        return this.type == Type.EXP_OR;
    }

    public boolean isNOT() {
        return this.type == Type.EXP_NOT;
    }

    public boolean isTRUE() {
        return this.type == Type.EXP_TRUE;
    }

    public boolean isFALSE() {
        return this.type == Type.EXP_FALSE;
    }

    public boolean isAtom() {
        return this.type == Type.EXP_ATOM;
    }

    public BooleanExpression<Atoms> and(BooleanExpression<Atoms> other) {
        return new BooleanExpression<Atoms>(Type.EXP_AND, this, other);
    }

    public BooleanExpression<Atoms> or(BooleanExpression<Atoms> other) {
        return new BooleanExpression<Atoms>(Type.EXP_OR, this, other);
    }

    public BooleanExpression<Atoms> not() {
        return new BooleanExpression<Atoms>(Type.EXP_NOT, this, null);
    }

    public static BitSet fromImplicit(long implicitIndex) {
        BitSet bs = new BitSet();
        int bit = 0;
        while (implicitIndex != 0L) {
            bs.set(bit, (implicitIndex & 1L) == 1L);
            implicitIndex >>= 2;
            ++bit;
        }
        return bs;
    }

    public static BooleanExpression<AtomLabel> fromImplicit(long implicitIndex, int apSize) {
        BooleanExpression<AtomLabel> result = null;
        BitSet bs = BooleanExpression.fromImplicit(implicitIndex);
        for (int i = 0; i < apSize; ++i) {
            BooleanExpression<AtomLabel> label = new BooleanExpression<AtomLabel>(AtomLabel.createAPIndex(new Integer(i)));
            if (!bs.get(i)) {
                label = label.not();
            }
            result = result != null ? result.and(label) : label;
        }
        return result;
    }

    public static boolean areSyntacticallyEqual(BooleanExpression<?> expr1, BooleanExpression<?> expr2) {
        if (expr1 == null || expr2 == null) {
            return false;
        }
        if (expr1.getType() != expr2.getType()) {
            return false;
        }
        switch (expr1.getType()) {
            case EXP_TRUE: 
            case EXP_FALSE: {
                return true;
            }
            case EXP_AND: 
            case EXP_OR: {
                if (!BooleanExpression.areSyntacticallyEqual(expr1.getLeft(), expr2.getLeft())) {
                    return false;
                }
                return BooleanExpression.areSyntacticallyEqual(expr1.getRight(), expr2.getRight());
            }
            case EXP_NOT: {
                return BooleanExpression.areSyntacticallyEqual(expr1.getLeft(), expr2.getLeft());
            }
            case EXP_ATOM: {
                return expr1.getAtom().equals(expr2.getAtom());
            }
        }
        throw new UnsupportedOperationException("Unknown operator in expression: " + expr1);
    }

    public boolean needsParentheses(Type enclosingType) {
        switch (this.type) {
            case EXP_TRUE: 
            case EXP_FALSE: 
            case EXP_ATOM: {
                return false;
            }
            case EXP_AND: {
                if (enclosingType == Type.EXP_NOT) {
                    return true;
                }
                if (enclosingType == Type.EXP_AND) {
                    return false;
                }
                if (enclosingType != Type.EXP_OR) break;
                return false;
            }
            case EXP_OR: {
                if (enclosingType == Type.EXP_NOT) {
                    return true;
                }
                if (enclosingType == Type.EXP_AND) {
                    return true;
                }
                if (enclosingType == Type.EXP_OR) {
                    return false;
                }
            }
            case EXP_NOT: {
                return false;
            }
        }
        throw new RuntimeException("Unhandled type");
    }

    public String toStringInfix() {
        StringBuilder result = new StringBuilder();
        switch (this.type) {
            case EXP_AND: {
                boolean paren = this.left.needsParentheses(Type.EXP_AND);
                if (paren) {
                    result.append("(");
                }
                result.append(this.left.toStringInfix());
                if (paren) {
                    result.append(")");
                }
                result.append(" & ");
                paren = this.right.needsParentheses(Type.EXP_AND);
                if (paren) {
                    result.append("(");
                }
                result.append(this.right.toStringInfix());
                if (paren) {
                    result.append(")");
                }
                return result.toString();
            }
            case EXP_OR: {
                boolean paren = this.left.needsParentheses(Type.EXP_OR);
                if (paren) {
                    result.append("(");
                }
                result.append(this.left.toStringInfix());
                if (paren) {
                    result.append(")");
                }
                result.append(" | ");
                paren = this.right.needsParentheses(Type.EXP_OR);
                if (paren) {
                    result.append("(");
                }
                result.append(this.right.toStringInfix());
                if (paren) {
                    result.append(")");
                }
                return result.toString();
            }
            case EXP_NOT: {
                boolean paren = this.left.needsParentheses(Type.EXP_NOT);
                result.append("!");
                if (paren) {
                    result.append("(");
                }
                result.append(this.left.toStringInfix());
                if (paren) {
                    result.append(")");
                }
                return result.toString();
            }
            case EXP_TRUE: {
                return "t";
            }
            case EXP_FALSE: {
                return "f";
            }
            case EXP_ATOM: {
                return this.getAtom().toString();
            }
        }
        throw new RuntimeException("Unhandled BooleanExpression type: " + this.type);
    }

    public String toString() {
        return this.toStringInfix();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.atom == null ? 0 : this.atom.hashCode());
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BooleanExpression)) {
            return false;
        }
        BooleanExpression other = (BooleanExpression)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.atom == null ? other.atom != null : !this.atom.equals(other.atom)) {
            return false;
        }
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        return !(this.right == null ? other.right != null : !this.right.equals(other.right));
    }

    public static enum Type {
        EXP_AND,
        EXP_OR,
        EXP_NOT,
        EXP_TRUE,
        EXP_FALSE,
        EXP_ATOM;

    }
}

