/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.consumer;

import java.util.ArrayList;
import java.util.List;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.consumer.HOAConsumerFactory;
import jhoafparser.consumer.HOAConsumerStore;
import jhoafparser.storage.StoredAutomaton;
import jhoafparser.storage.StoredAutomatonManipulator;

public class HOAIntermediateStoreAndManipulate
extends HOAConsumerStore {
    private List<StoredAutomatonManipulator> manipulators = new ArrayList<StoredAutomatonManipulator>();
    private HOAConsumer next;

    public HOAIntermediateStoreAndManipulate(StoredAutomatonManipulator ... manipulators) {
        this((HOAConsumer)null, manipulators);
    }

    public HOAIntermediateStoreAndManipulate(HOAConsumer next, StoredAutomatonManipulator ... manipulators) {
        this.next = next;
        for (StoredAutomatonManipulator manipulator : manipulators) {
            this.manipulators.add(manipulator);
        }
    }

    public static HOAConsumerFactory getFactory(final HOAConsumerFactory next, final StoredAutomatonManipulator ... manipulators) {
        return new HOAConsumerFactory(){

            @Override
            public HOAConsumer getNewHOAConsumer() {
                return new HOAIntermediateStoreAndManipulate(next.getNewHOAConsumer(), manipulators);
            }
        };
    }

    public void addManipulator(StoredAutomatonManipulator manipulator) {
        this.manipulators.add(manipulator);
    }

    @Override
    public void notifyEnd() throws HOAConsumerException {
        super.notifyEnd();
        StoredAutomaton aut = this.getStoredAutomaton();
        for (StoredAutomatonManipulator manipulator : this.manipulators) {
            aut = manipulator.manipulate(aut);
            this.setStoredAutomaton(aut);
        }
        if (this.next != null) {
            aut.feedToConsumer(this.next);
        }
    }
}

