/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm.simulations;

import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;

public final class SimulationUtil {
    private SimulationUtil() {
    }

    public static <S> Set<Set<S>> possibleKSets(Set<S> candidates, int k) {
        if (candidates.isEmpty()) {
            return Set.of();
        }
        assert (k > 0);
        HashSet output = new HashSet();
        candidates.forEach(candidate -> output.add(Set.of(candidate)));
        for (int i = 1; i < k; ++i) {
            HashSet toAdd = new HashSet();
            output.forEach(element -> candidates.forEach(candidate -> {
                HashSet<Object> temp = new HashSet<Object>((Collection<Object>)element);
                temp.add(candidate);
                toAdd.add(temp);
            }));
            output.addAll(toAdd);
        }
        return output;
    }

    public static <S, A extends BuchiAcceptance> Set<S> allSuccessors(Automaton<S, A> aut, Set<S> states, BitSet valuation) {
        return states.stream().map(state -> aut.successors(state, valuation)).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

