/*
 * Decompiled with CFR 0.152.
 */
package owl.cinterface;

import java.util.Arrays;
import java.util.Objects;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.type.CDoublePointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;
import owl.cinterface.CDoubleArray;
import owl.cinterface.emulation.EmulatedCDoublePointer;
import owl.util.ArraysSupport;

public final class CDoubleArrayList {
    private CDoublePointer elements;
    private int capacity;
    private int size;

    public CDoubleArrayList() {
        if (ImageInfo.inImageCode()) {
            this.elements = (CDoublePointer)UnmanagedMemory.malloc((UnsignedWord)CDoubleArrayList.toBytesLength(32L));
            this.capacity = 32;
        } else {
            this.elements = new EmulatedCDoublePointer(1);
            this.capacity = 1;
        }
        this.size = 0;
    }

    public void add(double value) {
        this.grow(this.size + 1);
        this.elements.write(this.size, value);
        ++this.size;
    }

    public double get(int index) {
        Objects.checkIndex(index, this.size);
        return this.elements.read(index);
    }

    public void set(int index, double value) {
        Objects.checkIndex(index, this.size);
        this.elements.write(index, value);
    }

    public int size() {
        return this.size;
    }

    public void moveToArray(CDoubleArray cDoubleArray) {
        if (this.size == Integer.MIN_VALUE) {
            throw new IllegalStateException("already moved");
        }
        cDoubleArray.elements((CDoublePointer)UnmanagedMemory.realloc((PointerBase)this.elements, (UnsignedWord)CDoubleArrayList.toBytesLength(this.size)));
        cDoubleArray.length(this.size);
        this.elements = (CDoublePointer)WordFactory.nullPointer();
        this.size = Integer.MIN_VALUE;
    }

    public double[] toArray() {
        int length = this.size;
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    private void grow(int minCapacity) {
        if (this.capacity >= minCapacity) {
            return;
        }
        int newCapacity = ArraysSupport.newLength(this.capacity, minCapacity - this.capacity, this.capacity >> 1);
        this.elements = ImageInfo.inImageCode() ? (CDoublePointer)UnmanagedMemory.realloc((PointerBase)this.elements, (UnsignedWord)CDoubleArrayList.toBytesLength(newCapacity)) : new EmulatedCDoublePointer((EmulatedCDoublePointer)this.elements, newCapacity);
        this.capacity = newCapacity;
    }

    private static UnsignedWord toBytesLength(long length) {
        return WordFactory.unsigned((long)(8L * length));
    }
}

