/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.robust;

import java.util.ArrayList;
import java.util.EnumSet;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.robust.Split;

public enum Robustness {
    NEVER{

        @Override
        Robustness stronger() {
            return EVENTUALLY;
        }

        @Override
        Robustness weaker() {
            throw new IllegalStateException(this + " is the bot element");
        }
    }
    ,
    EVENTUALLY{

        @Override
        Robustness stronger() {
            return INFINITELY_OFTEN;
        }

        @Override
        Robustness weaker() {
            return NEVER;
        }
    }
    ,
    INFINITELY_OFTEN{

        @Override
        Robustness stronger() {
            return EVENTUALLY_ALWAYS;
        }

        @Override
        Robustness weaker() {
            return EVENTUALLY;
        }
    }
    ,
    EVENTUALLY_ALWAYS{

        @Override
        Robustness stronger() {
            return ALWAYS;
        }

        @Override
        Robustness weaker() {
            return INFINITELY_OFTEN;
        }
    }
    ,
    ALWAYS{

        @Override
        Robustness stronger() {
            throw new IllegalStateException(this + " is the top element");
        }

        @Override
        Robustness weaker() {
            return EVENTUALLY_ALWAYS;
        }
    };


    public static Formula buildFormula(Split split, EnumSet<Robustness> robustness) {
        Robustness[] levels;
        if (robustness.isEmpty()) {
            return BooleanConstant.FALSE;
        }
        if (EnumSet.complementOf(robustness).isEmpty()) {
            return BooleanConstant.TRUE;
        }
        ArrayList<Formula> requirements = new ArrayList<Formula>();
        Robustness lowerBound = null;
        for (Robustness level : levels = Robustness.values()) {
            if (lowerBound == null && robustness.contains((Object)level)) {
                lowerBound = level;
                continue;
            }
            if (lowerBound == null || robustness.contains((Object)level)) continue;
            Formula upperBoundExpression = split.get(level).not();
            if (lowerBound == NEVER) {
                requirements.add(upperBoundExpression);
            } else {
                requirements.add(Conjunction.of(split.get(lowerBound), upperBoundExpression));
            }
            lowerBound = null;
        }
        if (lowerBound != null) {
            requirements.add(split.get(lowerBound));
        }
        return Disjunction.of(requirements);
    }

    abstract Robustness stronger();

    abstract Robustness weaker();
}

