/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.visitors;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import javax.annotation.Nonnegative;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.XOperator;
import owl.ltl.visitors.IntVisitor;

public class XDepthVisitor
implements IntVisitor {
    private static final Object2IntMap<Formula> CACHE = new Object2IntOpenHashMap();
    private static final XDepthVisitor INSTANCE = new XDepthVisitor();

    @Nonnegative
    public static int getDepth(Formula formula) {
        if (CACHE.size() > 1024) {
            CACHE.clear();
        }
        return (Integer)CACHE.computeIfAbsent((Object)formula, x -> x.accept(INSTANCE));
    }

    @Override
    @Nonnegative
    public int visit(FOperator fOperator) {
        return fOperator.operand().accept(this);
    }

    @Override
    @Nonnegative
    public int visit(GOperator gOperator) {
        return gOperator.operand().accept(this);
    }

    @Override
    @Nonnegative
    public int visit(BooleanConstant booleanConstant) {
        return 0;
    }

    @Override
    @Nonnegative
    public int visit(Conjunction conjunction) {
        return this.visit((Formula.NaryPropositionalOperator)conjunction);
    }

    @Override
    @Nonnegative
    public int visit(Disjunction disjunction) {
        return this.visit((Formula.NaryPropositionalOperator)disjunction);
    }

    @Override
    @Nonnegative
    public int visit(Literal literal) {
        return 0;
    }

    @Override
    @Nonnegative
    public int visit(XOperator xOperator) {
        return xOperator.operand().accept(this) + 1;
    }

    @Nonnegative
    private int visit(Formula.NaryPropositionalOperator formula) {
        int max = 0;
        for (Formula child : formula.operands) {
            max = Math.max(max, child.accept(this));
        }
        return max;
    }
}

