/*
 * Decompiled with CFR 0.152.
 */
package owl.translations;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import owl.automaton.Automaton;
import owl.automaton.hoa.HoaReader;
import owl.ltl.LabelledFormula;
import owl.ltl.visitors.PrintVisitor;
import owl.run.Environment;
import owl.run.modules.OwlModule;

public class ExternalTranslator
implements Function<LabelledFormula, Automaton<HoaReader.HoaState, ?>> {
    private static final Logger logger = Logger.getLogger(ExternalTranslator.class.getName());
    private static final Pattern splitPattern = Pattern.compile("\\s+");
    public static final OwlModule<OwlModule.Transformer> MODULE = OwlModule.of("ltl2aut-ext", "Runs an external tool for LTL to automaton translation", () -> {
        Option toolOption = new Option("t", "tool", true, "The tool invocation");
        toolOption.setRequired(true);
        Option inputType = new Option("i", "input", true, "How to pass the formula to the tool. Available modes are stdin or replace (add %f to the invocation)");
        return new Options().addOption(toolOption).addOption(inputType);
    }, (commandLine, environment) -> {
        String command = commandLine.getOptionValue("tool");
        String inputType = commandLine.getOptionValue("inputType");
        InputMode inputMode = InputMode.STDIN;
        if ("replace".equals(inputType)) {
            inputMode = InputMode.REPLACE;
        } else if (inputType != null && !"stdin".equals(inputType)) {
            throw new ParseException("Unknown input mode " + inputType);
        }
        ExternalTranslator translator = new ExternalTranslator(command, inputMode, environment);
        return OwlModule.LabelledFormulaTransformer.of(translator);
    });
    private final List<String> command;
    private final InputMode inputMode;
    private final Environment environment;

    public ExternalTranslator(String command, InputMode inputMode, Environment environment) {
        this(List.of(splitPattern.split(command)), inputMode, environment);
    }

    public ExternalTranslator(List<String> command, InputMode inputMode, Environment environment) {
        this.environment = environment;
        this.inputMode = inputMode;
        this.command = List.copyOf(command);
        if (inputMode == InputMode.REPLACE) {
            Preconditions.checkArgument((boolean)this.command.contains("%f"));
        }
    }

    @Override
    public Automaton<HoaReader.HoaState, ?> apply(LabelledFormula formula) {
        ProcessBuilder processBuilder;
        String formulaString = PrintVisitor.toString(formula, true);
        if (this.inputMode == InputMode.REPLACE) {
            ArrayList<String> adjustedCommand = new ArrayList<String>(this.command);
            adjustedCommand.replaceAll(x -> "%f".equals(x) ? formulaString : x);
            processBuilder = new ProcessBuilder(adjustedCommand);
        } else {
            processBuilder = new ProcessBuilder(this.command);
        }
        Process process = null;
        try {
            Automaton<HoaReader.HoaState, ?> automaton;
            process = processBuilder.start();
            logger.log(Level.FINER, "Running process {0}", processBuilder.command());
            if (this.inputMode == InputMode.STDIN) {
                try (OutputStreamWriter outputStream = new OutputStreamWriter(process.getOutputStream(), Charset.defaultCharset());){
                    logger.log(Level.FINER, "Passing {0} to process", formulaString);
                    outputStream.write(formulaString);
                    ((Writer)outputStream).write(10);
                }
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.defaultCharset()));
            try {
                automaton = HoaReader.read(reader, atomicPropositions -> {
                    Preconditions.checkArgument((boolean)formula.atomicPropositions().containsAll((Collection<?>)atomicPropositions));
                    return this.environment.factorySupplier().getValuationSetFactory(formula.atomicPropositions());
                });
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | NoSuchElementException | jhoafparser.parser.generated.ParseException ex) {
                    throw new CompletionException("Exception occurred while using external translator.", ex);
                }
            }
            ((Reader)reader).close();
            return automaton;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
                try {
                    process.waitFor(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {}
                process.destroyForcibly();
            }
        }
    }

    public static enum InputMode {
        STDIN,
        REPLACE;

    }
}

