/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dpa;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import owl.automaton.AnnotatedState;
import owl.collections.Collections3;
import owl.ltl.EquivalenceClass;
import owl.translations.ltl2dpa.AutoValue_SymmetricRankingState;
import owl.translations.ltl2ldba.SymmetricProductState;

@AutoValue
public abstract class SymmetricRankingState
implements AnnotatedState<Map<Integer, EquivalenceClass>> {
    @Override
    public abstract Map<Integer, EquivalenceClass> state();

    public abstract List<Map.Entry<Integer, SymmetricProductState>> ranking();

    public abstract int safetyBucket();

    public abstract int safetyBucketIndex();

    static SymmetricRankingState of(Map<Integer, EquivalenceClass> state) {
        return SymmetricRankingState.of(state, List.of(), 0, -1);
    }

    static SymmetricRankingState of(Map<Integer, EquivalenceClass> state, List<Map.Entry<Integer, SymmetricProductState>> ranking, int safetyBucket, int safetyBucketIndex) {
        Map<Integer, EquivalenceClass> copiedState = Map.copyOf(state);
        List<Map.Entry<Integer, SymmetricProductState>> copiedRanking = List.copyOf(ranking);
        Preconditions.checkState((safetyBucket == 0 && safetyBucketIndex == -1 || safetyBucket > 0 && safetyBucketIndex >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((safetyBucket == 0 || copiedState.containsKey(safetyBucket) ? 1 : 0) != 0);
        assert (Collections3.isDistinct(copiedRanking)) : "The ranking is not distinct: " + copiedRanking;
        return new AutoValue_SymmetricRankingState(copiedState, copiedRanking, safetyBucket, safetyBucketIndex);
    }

    public abstract boolean equals(Object var1);

    @Memoized
    public abstract int hashCode();

    public String toString() {
        if (this.safetyBucket() == 0) {
            return String.format("|%s :: %s|", this.state(), this.ranking());
        }
        return String.format("|%s :: %s :: %d (%d)|", this.state(), this.ranking(), this.safetyBucket(), this.safetyBucketIndex());
    }
}

