/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.mastertheorem;

import com.google.common.collect.Comparators;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.SyntacticFragments;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.BinaryVisitor;
import owl.translations.mastertheorem.Fixpoints;

class ExtendedRewriter {
    private static final Consumer<Formula> SENTINEL = x -> {};

    ExtendedRewriter() {
    }

    static final class ToCoSafety
    extends AdviceFunction {
        ToCoSafety(Fixpoints fixpoints, Consumer<? super Formula.TemporalOperator> consumer) {
            super(Mode.STRONG, fixpoints.leastFixpoints(), fixpoints.greatestFixpoints(), consumer, true);
        }
    }

    static final class ToSafety
    extends AdviceFunction {
        ToSafety(Fixpoints fixpoints, Consumer<? super Formula.TemporalOperator> consumer) {
            super(Mode.WEAK, fixpoints.leastFixpoints(), fixpoints.greatestFixpoints(), consumer, true);
        }

        ToSafety(Iterable<? extends Formula.TemporalOperator> x, Consumer<? super Formula.TemporalOperator> consumer) {
            super(Mode.WEAK, x, Set.of(), consumer, false);
        }
    }

    private static class AdviceFunction
    implements BinaryVisitor<Optional<Formula.TemporalOperator>, Formula> {
        private final Set<FOperator> fOperators;
        private final Set<MOperator> mOperators;
        private final Set<UOperator> uOperators;
        private final Set<GOperator> gOperators;
        private final Set<ROperator> rOperators;
        private final Set<WOperator> wOperators;
        private final Mode mode;
        private final boolean insideAlmostAll;
        private final Consumer<? super Formula.TemporalOperator> consumer;
        @Nullable
        private final AdviceFunction prerunAdviceFunction;

        private AdviceFunction(Mode mode, Iterable<? extends Formula.TemporalOperator> x, Iterable<? extends Formula.TemporalOperator> y, Consumer<? super Formula.TemporalOperator> consumer, boolean insideAlmostAll) {
            this.insideAlmostAll = insideAlmostAll;
            HashSet<FOperator> fOperators = new HashSet<FOperator>();
            HashSet<MOperator> mOperators = new HashSet<MOperator>();
            HashSet<UOperator> uOperators = new HashSet<UOperator>();
            HashSet<GOperator> gOperators = new HashSet<GOperator>();
            HashSet<ROperator> rOperators = new HashSet<ROperator>();
            HashSet<WOperator> wOperators = new HashSet<WOperator>();
            x.forEach(formula -> {
                if (formula instanceof FOperator) {
                    fOperators.add((FOperator)formula);
                } else if (formula instanceof MOperator) {
                    mOperators.add((MOperator)formula);
                } else if (formula instanceof UOperator) {
                    uOperators.add((UOperator)formula);
                } else {
                    throw new IllegalArgumentException(formula + " is not a least fixpoint modal operator.");
                }
            });
            y.forEach(formula -> {
                if (formula instanceof GOperator) {
                    gOperators.add((GOperator)formula);
                } else if (formula instanceof ROperator) {
                    rOperators.add((ROperator)formula);
                } else if (formula instanceof WOperator) {
                    wOperators.add((WOperator)formula);
                } else {
                    throw new IllegalArgumentException(formula + " is not a greatest fixpoint modal operator.");
                }
            });
            this.fOperators = Set.of((FOperator[])fOperators.toArray(FOperator[]::new));
            this.mOperators = Set.of((MOperator[])mOperators.toArray(MOperator[]::new));
            this.uOperators = Set.of((UOperator[])uOperators.toArray(UOperator[]::new));
            this.gOperators = Set.of((GOperator[])gOperators.toArray(GOperator[]::new));
            this.rOperators = Set.of((ROperator[])rOperators.toArray(ROperator[]::new));
            this.wOperators = Set.of((WOperator[])wOperators.toArray(WOperator[]::new));
            this.mode = mode;
            this.consumer = consumer;
            this.prerunAdviceFunction = this.consumer == SENTINEL ? null : new AdviceFunction(mode, fOperators, mOperators, uOperators, SENTINEL, gOperators, rOperators, wOperators, insideAlmostAll);
        }

        private AdviceFunction(Mode mode, Set<FOperator> fOperators, Set<MOperator> mOperators, Set<UOperator> uOperators, Consumer<? super Formula.TemporalOperator> consumer, Set<GOperator> gOperators, Set<ROperator> rOperators, Set<WOperator> wOperators, boolean insideAlmostAll) {
            this.fOperators = Set.copyOf(fOperators);
            this.mOperators = Set.copyOf(mOperators);
            this.uOperators = Set.copyOf(uOperators);
            this.gOperators = Set.copyOf(gOperators);
            this.rOperators = Set.copyOf(rOperators);
            this.wOperators = Set.copyOf(wOperators);
            this.mode = mode;
            this.consumer = consumer;
            this.insideAlmostAll = insideAlmostAll;
            this.prerunAdviceFunction = null;
        }

        public Formula apply(Formula.TemporalOperator formula) {
            return this.apply((Formula)formula, Optional.of(formula));
        }

        @Override
        public Formula apply(Formula formula, Optional<Formula.TemporalOperator> scope) {
            if (this.prerunAdviceFunction != null && this.prerunAdviceFunction.apply(formula, scope).equals(BooleanConstant.FALSE)) {
                return BooleanConstant.FALSE;
            }
            Formula rewrittenFormula = formula.accept(this, scope);
            assert (this.mode == Mode.WEAK && SyntacticFragments.isSafety(rewrittenFormula) || this.mode == Mode.STRONG && SyntacticFragments.isCoSafety(rewrittenFormula)) : formula + " -> " + rewrittenFormula;
            return rewrittenFormula;
        }

        @Override
        public Formula visit(BooleanConstant booleanConstant, Optional<Formula.TemporalOperator> scope) {
            return booleanConstant;
        }

        @Override
        public Formula visit(Literal literal, Optional<Formula.TemporalOperator> scope) {
            return literal;
        }

        @Override
        public Formula visit(Conjunction conjunction, Optional<Formula.TemporalOperator> scope) {
            HashSet<Formula> children = new HashSet<Formula>();
            assert (Comparators.isInStrictOrder((Iterable)conjunction.operands, Comparator.naturalOrder()));
            for (Formula child : conjunction.operands) {
                Formula visitedChild = child.accept(this, Optional.empty());
                if (visitedChild.equals(BooleanConstant.FALSE)) {
                    return BooleanConstant.FALSE;
                }
                children.add(visitedChild);
            }
            return Conjunction.of(children);
        }

        @Override
        public Formula visit(Disjunction disjunction, Optional<Formula.TemporalOperator> scope) {
            HashSet<Formula> children = new HashSet<Formula>();
            assert (Comparators.isInStrictOrder((Iterable)disjunction.operands, Comparator.naturalOrder()));
            for (Formula child : disjunction.operands) {
                Formula visitedChild = child.accept(this, Optional.empty());
                if (visitedChild.equals(BooleanConstant.TRUE)) {
                    return BooleanConstant.TRUE;
                }
                children.add(visitedChild);
            }
            return Disjunction.of(children);
        }

        @Override
        public Formula visit(XOperator xOperator, Optional<Formula.TemporalOperator> scope) {
            Formula operand = xOperator.operand().accept(this, Optional.empty());
            return operand instanceof BooleanConstant ? operand : new XOperator(operand);
        }

        @Override
        public Formula visit(FOperator fOperator, Optional<Formula.TemporalOperator> scope) {
            if (scope.isPresent() && fOperator.equals(scope.get())) {
                assert (this.mode == Mode.STRONG);
                return AdviceFunction.fOperator(fOperator.operand().accept(this, Optional.empty()));
            }
            this.consumer.accept(fOperator);
            return BooleanConstant.of(this.fOperators.contains(fOperator));
        }

        @Override
        public Formula visit(MOperator mOperator, Optional<Formula.TemporalOperator> scope) {
            if (scope.isPresent() && mOperator.equals(scope.get())) {
                assert (this.mode == Mode.STRONG);
                return AdviceFunction.mOperator(mOperator.leftOperand().accept(this, Optional.empty()), mOperator.rightOperand().accept(this, Optional.empty()));
            }
            FOperator fOperator = new FOperator(mOperator.leftOperand());
            this.consumer.accept(fOperator);
            this.consumer.accept(mOperator);
            if (this.fOperators.contains(fOperator) || this.mOperators.contains(mOperator)) {
                Formula left = mOperator.leftOperand().accept(this, Optional.empty());
                Formula right = mOperator.rightOperand().accept(this, Optional.empty());
                return this.mode == Mode.STRONG ? AdviceFunction.mOperator(left, right) : AdviceFunction.rOperator(left, right);
            }
            return BooleanConstant.FALSE;
        }

        @Override
        public Formula visit(UOperator uOperator, Optional<Formula.TemporalOperator> scope) {
            if (scope.isPresent() && uOperator.equals(scope.get())) {
                assert (this.mode == Mode.STRONG);
                return AdviceFunction.uOperator(uOperator.leftOperand().accept(this, Optional.empty()), uOperator.rightOperand().accept(this, Optional.empty()));
            }
            FOperator fOperator = new FOperator(uOperator.rightOperand());
            this.consumer.accept(fOperator);
            this.consumer.accept(uOperator);
            if (this.fOperators.contains(fOperator) || this.uOperators.contains(uOperator)) {
                Formula left = uOperator.leftOperand().accept(this, Optional.empty());
                Formula right = uOperator.rightOperand().accept(this, Optional.empty());
                return this.mode == Mode.STRONG ? AdviceFunction.uOperator(left, right) : AdviceFunction.wOperator(left, right);
            }
            return BooleanConstant.FALSE;
        }

        @Override
        public Formula visit(GOperator gOperator, Optional<Formula.TemporalOperator> scope) {
            if (scope.isPresent() && gOperator.equals(scope.get())) {
                assert (this.mode == Mode.WEAK);
                return AdviceFunction.gOperator(gOperator.operand().accept(this, Optional.empty()));
            }
            this.consumer.accept(gOperator);
            if (this.insideAlmostAll) {
                return BooleanConstant.of(this.gOperators.contains(gOperator));
            }
            assert (this.mode == Mode.WEAK);
            return AdviceFunction.gOperator(gOperator.operand().accept(this, Optional.empty()));
        }

        @Override
        public Formula visit(ROperator rOperator, Optional<Formula.TemporalOperator> scope) {
            if (scope.isPresent() && rOperator.equals(scope.get())) {
                assert (this.mode == Mode.WEAK);
                return AdviceFunction.rOperator(rOperator.leftOperand().accept(this, Optional.empty()), rOperator.rightOperand().accept(this, Optional.empty()));
            }
            GOperator gOperator = new GOperator(rOperator.rightOperand());
            this.consumer.accept(gOperator);
            this.consumer.accept(rOperator);
            if (this.gOperators.contains(gOperator) || this.rOperators.contains(rOperator)) {
                assert (this.insideAlmostAll);
                return BooleanConstant.TRUE;
            }
            Formula left = rOperator.leftOperand().accept(this, Optional.empty());
            Formula right = rOperator.rightOperand().accept(this, Optional.empty());
            return this.mode == Mode.WEAK ? AdviceFunction.rOperator(left, right) : AdviceFunction.mOperator(left, right);
        }

        @Override
        public Formula visit(WOperator wOperator, Optional<Formula.TemporalOperator> scope) {
            if (scope.isPresent() && wOperator.equals(scope.get())) {
                assert (this.mode == Mode.WEAK);
                return AdviceFunction.wOperator(wOperator.leftOperand().accept(this, Optional.empty()), wOperator.rightOperand().accept(this, Optional.empty()));
            }
            GOperator gOperator = new GOperator(wOperator.leftOperand());
            this.consumer.accept(gOperator);
            this.consumer.accept(wOperator);
            if (this.gOperators.contains(gOperator) || this.wOperators.contains(wOperator)) {
                assert (this.insideAlmostAll);
                return BooleanConstant.TRUE;
            }
            Formula left = wOperator.leftOperand().accept(this, Optional.empty());
            Formula right = wOperator.rightOperand().accept(this, Optional.empty());
            return this.mode == Mode.WEAK ? AdviceFunction.wOperator(left, right) : AdviceFunction.uOperator(left, right);
        }

        private static Formula fOperator(Formula operand) {
            if (operand instanceof BooleanConstant || operand instanceof FOperator) {
                return operand;
            }
            if (operand instanceof Disjunction) {
                return Disjunction.of(((Disjunction)operand).map(AdviceFunction::fOperator));
            }
            return new FOperator(operand);
        }

        private static Formula mOperator(Formula leftOperand, Formula rightOperand) {
            if (leftOperand instanceof BooleanConstant || leftOperand instanceof FOperator || leftOperand.equals(rightOperand) || rightOperand.equals(BooleanConstant.FALSE)) {
                return Conjunction.of(leftOperand, rightOperand);
            }
            if (rightOperand.equals(BooleanConstant.TRUE)) {
                return AdviceFunction.fOperator(leftOperand);
            }
            return new MOperator(leftOperand, rightOperand);
        }

        private static Formula uOperator(Formula leftOperand, Formula rightOperand) {
            if (rightOperand instanceof BooleanConstant || rightOperand instanceof FOperator || leftOperand.equals(rightOperand) || leftOperand.equals(BooleanConstant.FALSE)) {
                return rightOperand;
            }
            if (leftOperand.equals(BooleanConstant.TRUE)) {
                return AdviceFunction.fOperator(rightOperand);
            }
            return new UOperator(leftOperand, rightOperand);
        }

        private static Formula gOperator(Formula operand) {
            if (operand instanceof BooleanConstant || operand instanceof GOperator) {
                return operand;
            }
            if (operand instanceof Conjunction) {
                return Conjunction.of(((Conjunction)operand).map(AdviceFunction::gOperator));
            }
            return new GOperator(operand);
        }

        private static Formula rOperator(Formula leftOperand, Formula rightOperand) {
            if (rightOperand instanceof BooleanConstant || rightOperand instanceof GOperator || leftOperand.equals(rightOperand) || leftOperand.equals(BooleanConstant.TRUE)) {
                return rightOperand;
            }
            if (leftOperand.equals(BooleanConstant.FALSE)) {
                return AdviceFunction.gOperator(rightOperand);
            }
            return new ROperator(leftOperand, rightOperand);
        }

        private static Formula wOperator(Formula leftOperand, Formula rightOperand) {
            if (leftOperand instanceof BooleanConstant || leftOperand instanceof GOperator || leftOperand.equals(rightOperand) || rightOperand.equals(BooleanConstant.TRUE)) {
                return Disjunction.of(leftOperand, rightOperand);
            }
            if (rightOperand.equals(BooleanConstant.FALSE)) {
                return AdviceFunction.gOperator(leftOperand);
            }
            return new WOperator(leftOperand, rightOperand);
        }
    }

    static enum Mode {
        WEAK,
        STRONG;

    }
}

