/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import com.zaxxer.sparsebits.SparseBitSet;
import de.tum.in.naturals.set.AbstractNatBitSetFactory;
import de.tum.in.naturals.set.BoundedNatBitSet;
import de.tum.in.naturals.set.NatBitSet;
import de.tum.in.naturals.set.SimpleBoundedNatBitSet;
import de.tum.in.naturals.set.SimpleNatBitSet;
import de.tum.in.naturals.set.SparseBoundedNatBitSet;
import de.tum.in.naturals.set.SparseNatBitSet;
import java.util.BitSet;
import java.util.function.BiPredicate;

public class SparseNatBitSetFactory
extends AbstractNatBitSetFactory {
    private static final int SPARSE_THRESHOLD = 8192;
    private final BiPredicate<Integer, Integer> useSparse;

    SparseNatBitSetFactory() {
        this(SparseNatBitSetFactory::useSparse);
    }

    public SparseNatBitSetFactory(BiPredicate<Integer, Integer> useSparse) {
        this.useSparse = useSparse;
    }

    private static boolean useSparse(int expectedSize, int expectedLength) {
        if (expectedLength == -1) {
            if (expectedSize == -1) {
                return true;
            }
            if (expectedSize > 8192) {
                return true;
            }
        }
        return expectedLength > 8192 || expectedSize != -1 && expectedSize > 8192;
    }

    @Override
    protected BoundedNatBitSet makeBoundedSet(int domainSize, int expectedSize) {
        return this.useSparse.test(expectedSize, domainSize) ? new SparseBoundedNatBitSet(new SparseBitSet(domainSize), domainSize) : new SimpleBoundedNatBitSet(new BitSet(), domainSize);
    }

    @Override
    public NatBitSet set(int expectedSize, int expectedLength) {
        if (this.useSparse.test(expectedSize, expectedLength)) {
            SparseBitSet backingSet = expectedLength == -1 ? new SparseBitSet() : new SparseBitSet(expectedLength);
            return new SparseNatBitSet(backingSet);
        }
        return new SimpleNatBitSet(new BitSet());
    }
}

