/*
 * Decompiled with CFR 0.152.
 */
package owl.run.modules;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import owl.automaton.ParityUtil;
import owl.automaton.Views;
import owl.automaton.acceptance.degeneralization.BuchiDegeneralization;
import owl.automaton.acceptance.degeneralization.RabinDegeneralization;
import owl.automaton.acceptance.optimization.AcceptanceOptimizations;
import owl.automaton.algorithm.simulations.BuchiSimulation;
import owl.game.GameUtil;
import owl.game.GameViews;
import owl.game.algorithms.ZielonkaGameSolver;
import owl.ltl.rewriter.SimplifierTransformer;
import owl.ltl.robust.RobustLtlInputReader;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.OwlModule;
import owl.translations.ExternalTranslator;
import owl.translations.delag.DelagBuilder;
import owl.translations.dra2dpa.IARBuilder;
import owl.translations.modules.LTL2DAModule;
import owl.translations.modules.LTL2DGRAModule;
import owl.translations.modules.LTL2DPAModule;
import owl.translations.modules.LTL2DRAModule;
import owl.translations.modules.LTL2LDBAModule;
import owl.translations.modules.LTL2LDGBAModule;
import owl.translations.modules.LTL2NAModule;
import owl.translations.modules.LTL2NBAModule;
import owl.translations.modules.LTL2NGBAModule;
import owl.translations.modules.LTL2NormalFormModule;
import owl.translations.nba2dpa.NBA2DPA;
import owl.translations.nba2ldba.NBA2LDBA;
import owl.translations.nbadet.NbaDet;

public class OwlModuleRegistry {
    public static final OwlModuleRegistry DEFAULT_REGISTRY = new OwlModuleRegistry();
    private final Map<String, OwlModule<OwlModule.InputReader>> readers = new HashMap<String, OwlModule<OwlModule.InputReader>>();
    private final Map<String, OwlModule<OwlModule.Transformer>> transformers = new HashMap<String, OwlModule<OwlModule.Transformer>>();
    private final Map<String, OwlModule<OwlModule.OutputWriter>> writers = new HashMap<String, OwlModule<OwlModule.OutputWriter>>();

    public OwlModule<OwlModule.InputReader> getReader(String name) throws OwlModuleNotFoundException {
        OwlModule<OwlModule.InputReader> module = this.readers.get(name);
        if (module == null) {
            throw new OwlModuleNotFoundException(Type.READER, name);
        }
        return module;
    }

    public OwlModule<OwlModule.Transformer> getTransformer(String name) throws OwlModuleNotFoundException {
        OwlModule<OwlModule.Transformer> module = this.transformers.get(name);
        if (module == null) {
            throw new OwlModuleNotFoundException(Type.TRANSFORMER, name);
        }
        return module;
    }

    public OwlModule<OwlModule.OutputWriter> getWriter(String name) throws OwlModuleNotFoundException {
        OwlModule<OwlModule.OutputWriter> module = this.writers.get(name);
        if (module == null) {
            throw new OwlModuleNotFoundException(Type.WRITER, name);
        }
        return module;
    }

    public Collection<OwlModule<?>> get(Type type) {
        switch (type) {
            case READER: {
                return this.readers.values();
            }
            case WRITER: {
                return this.writers.values();
            }
            case TRANSFORMER: {
                return this.transformers.values();
            }
        }
        throw new AssertionError((Object)"Unreachable.");
    }

    public Map<Type, OwlModule<?>> get(String name) {
        OwlModule<OwlModule.Transformer> writer;
        OwlModule<OwlModule.Transformer> transformer;
        EnumMap types = new EnumMap(Type.class);
        OwlModule<OwlModule.InputReader> reader = this.readers.get(name);
        if (reader != null) {
            types.put(Type.READER, reader);
        }
        if ((transformer = this.transformers.get(name)) != null) {
            types.put(Type.TRANSFORMER, reader);
        }
        if ((writer = this.transformers.get(name)) != null) {
            types.put(Type.WRITER, reader);
        }
        return types;
    }

    public Type type(OwlModule<?> object) {
        Map<Type, OwlModule<?>> typeMap = this.get(object.key());
        return typeMap.keySet().iterator().next();
    }

    public void putReaders(List<OwlModule<OwlModule.InputReader>> modules) {
        modules.forEach(module -> this.put(this.readers, (OwlModule)module));
    }

    public void putTransformers(List<OwlModule<OwlModule.Transformer>> modules) {
        modules.forEach(module -> this.put(this.transformers, (OwlModule)module));
    }

    public void registerWriter(List<OwlModule<OwlModule.OutputWriter>> modules) {
        modules.forEach(module -> this.put(this.writers, (OwlModule)module));
    }

    private <M extends OwlModule.Instance> void put(Map<String, OwlModule<M>> map, OwlModule<M> module) {
        String key = module.key();
        if (map.containsKey(key)) {
            throw new IllegalArgumentException(String.format("Module with name %s already registered", module.key()));
        }
        map.put(key, module);
    }

    static {
        DEFAULT_REGISTRY.putReaders(List.of(InputReaders.LTL_INPUT_MODULE, InputReaders.HOA_INPUT_MODULE, RobustLtlInputReader.RLTL_INPUT_MODULE));
        DEFAULT_REGISTRY.registerWriter(List.of(OutputWriters.TO_STRING_MODULE, OutputWriters.AUTOMATON_STATS_MODULE, OutputWriters.NULL_MODULE, OutputWriters.HOA_OUTPUT_MODULE, GameUtil.PG_SOLVER_OUTPUT_MODULE));
        DEFAULT_REGISTRY.putTransformers(List.of(SimplifierTransformer.MODULE, GameViews.AUTOMATON_TO_GAME_MODULE, AcceptanceOptimizations.MODULE, BuchiDegeneralization.MODULE, RabinDegeneralization.MODULE, Views.COMPLETE_MODULE));
        DEFAULT_REGISTRY.putTransformers(List.of(LTL2NBAModule.MODULE, LTL2NGBAModule.MODULE, LTL2LDBAModule.MODULE, LTL2LDGBAModule.MODULE, LTL2DRAModule.MODULE, LTL2DGRAModule.MODULE, LTL2DPAModule.MODULE, LTL2DAModule.MODULE, DelagBuilder.MODULE, LTL2NAModule.MODULE, ExternalTranslator.MODULE, LTL2NormalFormModule.MODULE));
        DEFAULT_REGISTRY.putTransformers(List.of(IARBuilder.MODULE, NBA2LDBA.MODULE, NBA2DPA.MODULE, NbaDet.MODULE, BuchiSimulation.MODULE, ParityUtil.COMPLEMENT_MODULE, ParityUtil.CONVERSION_MODULE, ZielonkaGameSolver.ZIELONKA_SOLVER));
    }

    public static class OwlModuleNotFoundException
    extends Exception {
        public final Type type;
        public final String name;

        OwlModuleNotFoundException(Type type, String name) {
            this.type = type;
            this.name = name;
        }
    }

    public static enum Type {
        READER,
        TRANSFORMER,
        WRITER;

    }
}

