/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nbadet;

import com.google.auto.value.AutoValue;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Streams;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.algorithm.SccDecomposition;
import owl.collections.Pair;
import owl.translations.nbadet.AutoValue_NbaDetConf;
import owl.translations.nbadet.NbaAdjMat;
import owl.translations.nbadet.NbaDet;
import owl.translations.nbadet.NbaDetArgs;
import owl.translations.nbadet.NbaDetConfSets;
import owl.translations.nbadet.NbaLangInclusions;
import owl.translations.nbadet.NbaSccInfo;
import owl.translations.nbadet.SubsumedStatesMap;
import owl.util.BitSetUtil;

@AutoValue
public abstract class NbaDetConf<S> {
    private static final Logger logger = Logger.getLogger(NbaDet.class.getName());

    public abstract NbaDetArgs args();

    public abstract NbaAdjMat<S> aut();

    public abstract BitSet accSinks();

    public abstract SubsumedStatesMap extMask();

    public abstract SubsumedStatesMap intMask();

    public abstract NbaDetConfSets sets();

    public NbaDetConf<S> withUpdateMode(UpdateMode mode) {
        NbaDetArgs modargs = this.args().toBuilder().setMergeMode(mode).build();
        return new AutoValue_NbaDetConf<S>(modargs, this.aut(), this.accSinks(), this.extMask(), this.intMask(), this.sets());
    }

    public static <S> Set<Pair<S, S>> filterInternalIncl(Set<Pair<S, S>> incl, NbaSccInfo<S> scci) {
        return incl.stream().filter(p -> !p.fst().equals(p.snd()) && scci.sccDecomposition().index(p.fst()) == scci.sccDecomposition().index(p.snd())).collect(Collectors.toUnmodifiableSet());
    }

    public static <S> Set<Pair<S, S>> filterExternalIncl(Set<Pair<S, S>> incl, NbaSccInfo<S> scci, BiMap<S, Integer> stm) {
        Set inclFilt = incl.stream().filter(p -> !scci.isStateReachable(p.snd(), p.fst())).collect(Collectors.toSet());
        HashMap leq = new HashMap();
        for (Pair p2 : inclFilt) {
            if (!leq.containsKey(p2.fst())) {
                leq.put(p2.fst(), new HashSet());
            }
            ((Set)leq.get(p2.fst())).add(p2.snd());
        }
        HashMap<Object, Integer> eqClass = new HashMap<Object, Integer>();
        int i = 0;
        for (Set<Object> eqcl : SccDecomposition.of(leq.keySet(), x -> leq.getOrDefault(x, Set.of())).sccs()) {
            for (Object st : eqcl) {
                eqClass.put(st, i);
            }
            ++i;
        }
        return inclFilt.stream().filter(p -> !((Integer)eqClass.get(p.fst())).equals(eqClass.get(p.snd())) || (Integer)stm.get(p.fst()) < (Integer)stm.get(p.snd())).collect(Collectors.toUnmodifiableSet());
    }

    public static <S> NbaDetConf<S> prepare(Automaton<S, BuchiAcceptance> aut, Set<Pair<S, S>> incl, NbaDetArgs args) {
        NbaSccInfo<S> scci = NbaSccInfo.of(aut);
        Set<S> states = aut.states();
        ImmutableBiMap stateMap = ImmutableBiMap.copyOf(Streams.mapWithIndex(states.stream(), (k, i) -> Pair.of(k, (int)i)).collect(Collectors.toUnmodifiableMap(Pair::fst, Pair::snd)));
        NbaDetConfSets sccSets = NbaDetConfSets.of(args, scci, stateMap);
        Set<S> aSinks = NbaLangInclusions.getNbaAccPseudoSinks(aut);
        Set<Pair<S, S>> extIncl = NbaDetConf.filterExternalIncl(incl, scci, stateMap);
        Set<Pair<S, S>> intIncl = NbaDetConf.filterInternalIncl(incl, scci);
        BitSet aSinksBS = BitSetUtil.fromSet(aSinks, stateMap);
        SubsumedStatesMap extMask = args.simExt() ? SubsumedStatesMap.of(stateMap, extIncl) : SubsumedStatesMap.empty();
        SubsumedStatesMap intMask = args.simInt() ? SubsumedStatesMap.of(stateMap, intIncl) : SubsumedStatesMap.empty();
        NbaAdjMat<S> adjMat = new NbaAdjMat<S>(aut, stateMap, aSinks, extMask);
        AutoValue_NbaDetConf<S> ret = new AutoValue_NbaDetConf<S>(args, adjMat, aSinksBS, extMask, intMask, sccSets);
        if (logger.getLevel() != null) {
            if (logger.getLevel().equals(Level.FINER)) {
                logger.log(Level.FINER, ret.toString());
            } else if (logger.getLevel().equals(Level.FINEST)) {
                logger.log(Level.FINEST, "NBA adj. mat. - state -> (accSucc, rejSucc)\n" + adjMat.toString());
            }
        }
        return ret;
    }

    public String toString() {
        Function<Integer, Object> inv = arg_0 -> ((ImmutableBiMap)this.aut().stateMap().inverse()).get(arg_0);
        StringBuilder sb = new StringBuilder();
        sb.append("assembled NBA determinization configuration:").append("\nstate to bit mapping: ").append(this.aut().stateMap().inverse().toString()).append("\ndetected accepting pseudo-sinks: ").append(BitSetUtil.toSet(this.accSinks(), inv).toString()).append("\nused external language inclusions:\n").append(this.extMask().toString(inv)).append("used internal language inclusions:\n").append(this.intMask().toString(inv)).append("determinization components:").append("\nrScc(s): ").append(BitSetUtil.toSet(this.sets().rsccStates(), inv));
        this.sets().asccsStates().forEach(s -> sb.append("\naScc: ").append(BitSetUtil.toSet(s, inv)));
        this.sets().dsccsStates().forEach(s -> sb.append("\ndScc: ").append(BitSetUtil.toSet(s, inv)));
        this.sets().msccsStates().forEach(s -> sb.append("\nmScc: ").append(BitSetUtil.toSet(s, inv)));
        return sb.toString();
    }

    public static enum UpdateMode {
        MUELLER_SCHUPP,
        SAFRA,
        MAX_MERGE;

    }
}

