/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.rabinizer;

import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import owl.automaton.edge.Edge;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.MOperator;
import owl.ltl.SyntacticFragment;
import owl.ltl.UOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.Converter;
import owl.ltl.visitors.Visitor;
import owl.translations.rabinizer.GSet;
import owl.translations.rabinizer.MonitorState;
import owl.translations.rabinizer.RabinizerState;

class RabinizerStateFactory {
    final boolean eager;

    RabinizerStateFactory(boolean eager) {
        this.eager = eager;
    }

    BitSet getClassSensitiveAlphabet(EquivalenceClass equivalenceClass) {
        return this.eager ? equivalenceClass.atomicPropositions() : equivalenceClass.unfold().atomicPropositions();
    }

    static final class MonitorStateFactory
    extends RabinizerStateFactory {
        private static final Visitor<Formula> substitutionVisitor = new MonitorUnfoldVisitor();
        private static final Function<Formula, Formula> unfolding = f -> f.accept(substitutionVisitor);
        private final boolean noSubFormula;

        MonitorStateFactory(boolean eager, boolean noSubFormula) {
            super(eager);
            this.noSubFormula = noSubFormula;
        }

        static boolean isAccepting(EquivalenceClass equivalenceClass, GSet context) {
            return context.conjunction().implies(equivalenceClass);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static boolean isSink(EquivalenceClass equivalenceClass) {
            if (!equivalenceClass.atomicPropositions().isEmpty()) return false;
            if (!equivalenceClass.temporalOperators().stream().allMatch(GOperator.class::isInstance)) return false;
            return true;
        }

        EquivalenceClass getInitialState(EquivalenceClass formula) {
            return this.eager ? formula.substitute(unfolding) : formula;
        }

        EquivalenceClass getRankSuccessor(EquivalenceClass equivalenceClass, BitSet valuation) {
            if (this.noSubFormula) {
                return this.eager ? equivalenceClass.temporalStep(valuation).unfold() : equivalenceClass.unfold().temporalStep(valuation);
            }
            return this.eager ? equivalenceClass.temporalStep(valuation).substitute(unfolding) : equivalenceClass.substitute(unfolding).temporalStep(valuation);
        }

        BitSet getSensitiveAlphabet(MonitorState state) {
            List<EquivalenceClass> ranking = state.formulaRanking();
            if (ranking.isEmpty()) {
                return new BitSet(0);
            }
            Iterator<EquivalenceClass> iterator = ranking.iterator();
            BitSet sensitiveAlphabet = this.getClassSensitiveAlphabet(iterator.next());
            while (iterator.hasNext()) {
                sensitiveAlphabet.or(this.getClassSensitiveAlphabet(iterator.next()));
            }
            return sensitiveAlphabet;
        }

        private static final class MonitorUnfoldVisitor
        extends Converter {
            MonitorUnfoldVisitor() {
                super(SyntacticFragment.FGMU);
            }

            @Override
            public Formula visit(GOperator gOperator) {
                return gOperator;
            }

            @Override
            public Formula visit(XOperator xOperator) {
                return xOperator;
            }

            @Override
            public Formula visit(FOperator fOperator) {
                return Disjunction.of(fOperator.operand().accept(this), (Formula)fOperator);
            }

            @Override
            public Formula visit(UOperator uOperator) {
                return Disjunction.of(uOperator.rightOperand().accept(this), Conjunction.of(uOperator.leftOperand().accept(this), (Formula)uOperator));
            }

            @Override
            public Formula visit(MOperator mOperator) {
                return Conjunction.of(mOperator.rightOperand().accept(this), Disjunction.of(mOperator.leftOperand().accept(this), (Formula)mOperator));
            }
        }
    }

    static final class MasterStateFactory
    extends RabinizerStateFactory {
        private final boolean fairnessFragment;

        MasterStateFactory(boolean eager, boolean fairnessFragment) {
            super(eager);
            assert (!fairnessFragment || eager);
            this.fairnessFragment = fairnessFragment;
        }

        EquivalenceClass getInitialState(EquivalenceClass formula) {
            return this.eager ? formula.unfold() : formula;
        }

        @Nullable
        Edge<EquivalenceClass> getSuccessor(EquivalenceClass state, BitSet valuation) {
            EquivalenceClass successor = this.eager ? (this.fairnessFragment ? state : state.temporalStep(valuation).unfold()) : state.unfold().temporalStep(valuation);
            return successor.isFalse() ? null : Edge.of(successor);
        }
    }

    static final class ProductStateFactory
    extends RabinizerStateFactory {
        ProductStateFactory(boolean eager) {
            super(eager);
        }

        BitSet getSensitiveAlphabet(RabinizerState state) {
            BitSet sensitiveAlphabet = this.getClassSensitiveAlphabet(state.masterState());
            for (MonitorState monitorState : state.monitorStates()) {
                for (EquivalenceClass rankedFormula : monitorState.formulaRanking()) {
                    sensitiveAlphabet.or(this.getClassSensitiveAlphabet(rankedFormula));
                }
            }
            return sensitiveAlphabet;
        }
    }
}

