/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.extensions;

import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import jhoafparser.ast.Atom;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.BooleanExpression;
import owl.logic.propositional.PropositionalFormula;

public final class BooleanExpressions {
    private BooleanExpressions() {
    }

    public static <T extends Atom> BooleanExpression<T> createConjunction(Iterable<BooleanExpression<T>> conjuncts) {
        Iterator<BooleanExpression<T>> iterator = conjuncts.iterator();
        if (!iterator.hasNext()) {
            return new BooleanExpression(true);
        }
        BooleanExpression conjunction = iterator.next();
        while (iterator.hasNext()) {
            conjunction = conjunction.and(iterator.next());
        }
        return conjunction;
    }

    public static BooleanExpression<AtomAcceptance> mkFin(int number) {
        return new BooleanExpression((Atom)new AtomAcceptance(AtomAcceptance.Type.TEMPORAL_FIN, Integer.valueOf(number), false));
    }

    public static BooleanExpression<AtomAcceptance> mkInf(int number) {
        return new BooleanExpression((Atom)new AtomAcceptance(AtomAcceptance.Type.TEMPORAL_INF, Integer.valueOf(number), false));
    }

    private static boolean isConjunctive(BooleanExpression<AtomAcceptance> acc) {
        switch (acc.getType()) {
            case EXP_FALSE: 
            case EXP_TRUE: 
            case EXP_ATOM: {
                return true;
            }
            case EXP_AND: {
                return BooleanExpressions.isConjunctive((BooleanExpression<AtomAcceptance>)acc.getLeft()) && BooleanExpressions.isConjunctive((BooleanExpression<AtomAcceptance>)acc.getRight());
            }
            case EXP_OR: {
                return false;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in acceptance condition " + acc);
    }

    private static List<BooleanExpression<AtomAcceptance>> toDnf(BooleanExpression<AtomAcceptance> acc, Map<BooleanExpression<AtomAcceptance>, BooleanExpression<AtomAcceptance>> uniqueTable) {
        if (BooleanExpressions.isConjunctive(acc)) {
            return List.of(uniqueTable.computeIfAbsent(acc, Function.identity()));
        }
        ArrayList<BooleanExpression<AtomAcceptance>> dnf = new ArrayList<BooleanExpression<AtomAcceptance>>();
        switch (acc.getType()) {
            case EXP_AND: {
                List<BooleanExpression<AtomAcceptance>> left = BooleanExpressions.toDnf((BooleanExpression<AtomAcceptance>)acc.getLeft(), uniqueTable);
                List<BooleanExpression<AtomAcceptance>> right = BooleanExpressions.toDnf((BooleanExpression<AtomAcceptance>)acc.getRight(), uniqueTable);
                for (BooleanExpression<AtomAcceptance> l : left) {
                    for (BooleanExpression<AtomAcceptance> r : right) {
                        BooleanExpression conjunction = l.and(r);
                        dnf.add(uniqueTable.computeIfAbsent((BooleanExpression<AtomAcceptance>)conjunction, Function.identity()));
                    }
                }
                return dnf;
            }
            case EXP_OR: {
                dnf.addAll(BooleanExpressions.toDnf((BooleanExpression<AtomAcceptance>)acc.getLeft(), uniqueTable));
                dnf.addAll(BooleanExpressions.toDnf((BooleanExpression<AtomAcceptance>)acc.getRight(), uniqueTable));
                return dnf;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in acceptance condition: " + acc);
    }

    public static List<BooleanExpression<AtomAcceptance>> toDnf(BooleanExpression<AtomAcceptance> acc) {
        return BooleanExpressions.toDnf(acc, new HashMap<BooleanExpression<AtomAcceptance>, BooleanExpression<AtomAcceptance>>());
    }

    public static PropositionalFormula<Integer> toPropositionalFormula(BooleanExpression<? extends AtomAcceptance> expression) {
        switch (expression.getType()) {
            case EXP_FALSE: {
                return PropositionalFormula.falseConstant();
            }
            case EXP_TRUE: {
                return PropositionalFormula.trueConstant();
            }
            case EXP_ATOM: {
                AtomAcceptance atom = (AtomAcceptance)expression.getAtom();
                if (atom.getType() == AtomAcceptance.Type.TEMPORAL_INF) {
                    return atom.isNegated() ? PropositionalFormula.Negation.of(PropositionalFormula.Variable.of(atom.getAcceptanceSet())) : PropositionalFormula.Variable.of(atom.getAcceptanceSet());
                }
                assert (atom.getType() == AtomAcceptance.Type.TEMPORAL_FIN);
                return atom.isNegated() ? PropositionalFormula.Variable.of(atom.getAcceptanceSet()) : PropositionalFormula.Negation.of(PropositionalFormula.Variable.of(atom.getAcceptanceSet()));
            }
            case EXP_AND: {
                return PropositionalFormula.Conjunction.of(BooleanExpressions.toPropositionalFormula((BooleanExpression<? extends AtomAcceptance>)expression.getLeft()), BooleanExpressions.toPropositionalFormula((BooleanExpression<? extends AtomAcceptance>)expression.getRight()));
            }
            case EXP_OR: {
                return PropositionalFormula.Disjunction.of(BooleanExpressions.toPropositionalFormula((BooleanExpression<? extends AtomAcceptance>)expression.getLeft()), BooleanExpressions.toPropositionalFormula((BooleanExpression<? extends AtomAcceptance>)expression.getRight()));
            }
            case EXP_NOT: {
                return PropositionalFormula.Negation.of(BooleanExpressions.toPropositionalFormula((BooleanExpression<? extends AtomAcceptance>)expression.getLeft()));
            }
        }
        throw new AssertionError((Object)("Encountered unknown expression " + expression));
    }

    public static BooleanExpression<AtomAcceptance> fromPropositionalFormula(PropositionalFormula<Integer> formula) {
        return BooleanExpressions.fromPropositionalFormula(formula, BooleanExpressions::mkInf, BooleanExpressions::mkFin);
    }

    public static <A extends Atom> BooleanExpression<A> fromPropositionalFormula(PropositionalFormula<Integer> formula, Function<? super Integer, ? extends BooleanExpression<A>> mapper) {
        return BooleanExpressions.fromPropositionalFormula(formula, mapper, x -> ((BooleanExpression)mapper.apply((Integer)x)).not());
    }

    public static <A extends Atom> BooleanExpression<A> fromPropositionalFormula(PropositionalFormula<Integer> formula, Function<? super Integer, ? extends BooleanExpression<A>> mapper, Function<? super Integer, ? extends BooleanExpression<A>> negatedMapper) {
        if (formula instanceof PropositionalFormula.Variable) {
            return mapper.apply((Integer)((PropositionalFormula.Variable)formula).variable);
        }
        if (formula instanceof PropositionalFormula.Negation) {
            PropositionalFormula<Integer> operand = ((PropositionalFormula.Negation)formula).operand;
            if (operand instanceof PropositionalFormula.Variable) {
                return negatedMapper.apply((Integer)((PropositionalFormula.Variable)operand).variable);
            }
            return BooleanExpressions.fromPropositionalFormula(operand, mapper, negatedMapper).not();
        }
        if (formula instanceof PropositionalFormula.Conjunction) {
            ArrayDeque conjuncts = ((PropositionalFormula.Conjunction)formula).conjuncts.stream().map(x -> BooleanExpressions.fromPropositionalFormula(x, mapper, negatedMapper)).collect(Collectors.toCollection(ArrayDeque::new));
            if (conjuncts.isEmpty()) {
                return new BooleanExpression(true);
            }
            while (conjuncts.size() > 1) {
                BooleanExpression right = (BooleanExpression)conjuncts.removeLast();
                BooleanExpression left = (BooleanExpression)conjuncts.removeLast();
                conjuncts.addLast(left.and(right));
            }
            return (BooleanExpression)Iterables.getOnlyElement((Iterable)conjuncts);
        }
        if (formula instanceof PropositionalFormula.Disjunction) {
            ArrayDeque disjuncts = ((PropositionalFormula.Disjunction)formula).disjuncts.stream().map(x -> BooleanExpressions.fromPropositionalFormula(x, mapper, negatedMapper)).collect(Collectors.toCollection(ArrayDeque::new));
            if (disjuncts.isEmpty()) {
                return new BooleanExpression(false);
            }
            while (disjuncts.size() > 1) {
                BooleanExpression right = (BooleanExpression)disjuncts.removeLast();
                BooleanExpression left = (BooleanExpression)disjuncts.removeLast();
                disjuncts.addLast(left.or(right));
            }
            return (BooleanExpression)Iterables.getOnlyElement((Iterable)disjuncts);
        }
        throw new AssertionError((Object)("Encountered unknown type of " + formula));
    }
}

