/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.extensions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;

public class HOAConsumerPrintFixed
implements HOAConsumer {
    private static final Pattern PATTERN_1 = Pattern.compile("\\\\");
    private static final Pattern PATTERN_2 = Pattern.compile("\"");
    private BufferedWriter out;

    public HOAConsumerPrintFixed(Writer out) {
        this.out = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    public boolean parserResolvesAliases() {
        return false;
    }

    public void notifyHeaderStart(String version) throws HOAConsumerException {
        try {
            this.out.write("HOA: " + version);
            this.out.newLine();
        }
        catch (IOException e) {
            throw new HOAConsumerException(e.toString());
        }
    }

    public void setNumberOfStates(int numberOfStates) throws HOAConsumerException {
        try {
            this.out.write("States: " + numberOfStates);
            this.out.newLine();
        }
        catch (IOException e) {
            throw new HOAConsumerException(e.toString());
        }
    }

    public void addStartStates(List<Integer> stateConjunction) throws HOAConsumerException {
        try {
            this.out.write("Start: ");
            boolean first = true;
            for (Integer state : stateConjunction) {
                if (!first) {
                    this.out.write(" & ");
                }
                first = false;
                this.out.write(state.toString());
            }
            this.out.newLine();
        }
        catch (IOException e) {
            throw new HOAConsumerException(e.toString());
        }
    }

    public void addAlias(String name, BooleanExpression<AtomLabel> labelExpr) throws HOAConsumerException {
        try {
            this.out.write(String.format("Alias: @%s %s", name, labelExpr));
            this.out.newLine();
        }
        catch (IOException e) {
            throw new HOAConsumerException(e.toString());
        }
    }

    public void setAPs(List<String> aps) throws HOAConsumerException {
        try {
            this.out.write("AP: ");
            this.out.write(Integer.toString(aps.size()));
            for (String ap : aps) {
                this.out.write(" ");
                this.out.write(HOAConsumerPrintFixed.quoteString(ap));
            }
            this.out.newLine();
        }
        catch (IOException e) {
            throw new HOAConsumerException(e.toString());
        }
    }

    public void setAcceptanceCondition(int numberOfSets, BooleanExpression<AtomAcceptance> accExpr) throws HOAConsumerException {
        try {
            this.out.write("Acceptance: ");
            this.out.write(Integer.toString(numberOfSets));
            this.out.write(" ");
            this.out.write(accExpr.toString());
            this.out.newLine();
        }
        catch (IOException e) {
            throw new HOAConsumerException(e.toString());
        }
    }

    public void provideAcceptanceName(String name, List<Object> extraInfo) throws HOAConsumerException {
        try {
            this.out.write("acc-name: ");
            this.out.write(name);
            for (Object info : extraInfo) {
                this.out.write(" ");
                this.out.write(info.toString());
            }
            this.out.newLine();
        }
        catch (IOException e) {
            throw new HOAConsumerException(e.toString());
        }
    }

    public void setName(String name) throws HOAConsumerException {
        try {
            this.out.write("name: ");
            this.out.write(HOAConsumerPrintFixed.quoteString(name));
            this.out.newLine();
        }
        catch (IOException e) {
            throw new HOAConsumerException(e.toString());
        }
    }

    public void setTool(String name, String version) throws HOAConsumerException {
        try {
            this.out.write("tool: ");
            this.out.write(HOAConsumerPrintFixed.quoteString(name));
            if (version != null) {
                this.out.write(" " + HOAConsumerPrintFixed.quoteString(version));
            }
            this.out.newLine();
        }
        catch (IOException e) {
            throw new HOAConsumerException(e.toString());
        }
    }

    public void addProperties(List<String> properties) throws HOAConsumerException {
        try {
            this.out.write("properties: ");
            for (String property : properties) {
                this.out.write(property);
                this.out.write(" ");
            }
            this.out.newLine();
        }
        catch (IOException e) {
            throw new HOAConsumerException(e.toString());
        }
    }

    public void addMiscHeader(String name, List<Object> content) throws HOAConsumerException {
        try {
            this.out.write(name + ": ");
            for (Object c : content) {
                this.out.write(c.toString());
                this.out.write(" ");
            }
            this.out.newLine();
        }
        catch (IOException e) {
            throw new HOAConsumerException(e.toString());
        }
    }

    public void notifyBodyStart() throws HOAConsumerException {
        try {
            this.out.write("--BODY--");
            this.out.newLine();
        }
        catch (IOException e) {
            throw new HOAConsumerException(e.toString());
        }
    }

    public void addState(int id, String info, BooleanExpression<AtomLabel> labelExpr, @Nullable List<Integer> accSignature) throws HOAConsumerException {
        try {
            this.out.write("State: ");
            if (labelExpr != null) {
                this.out.write(String.format("[%s] ", labelExpr));
            }
            this.out.write(Integer.toString(id));
            if (info != null) {
                this.out.write(" ");
                this.out.write(HOAConsumerPrintFixed.quoteString(info));
            }
            if (accSignature != null && !accSignature.isEmpty()) {
                this.out.write(" {");
                boolean first = true;
                for (Integer acc : accSignature) {
                    if (!first) {
                        this.out.write(" ");
                    }
                    first = false;
                    this.out.write(acc.toString());
                }
                this.out.write("}");
            }
            this.out.newLine();
        }
        catch (IOException e) {
            throw new HOAConsumerException(e.toString());
        }
    }

    public void addEdgeImplicit(int stateId, List<Integer> conjSuccessors, @Nullable List<Integer> accSignature) throws HOAConsumerException {
        try {
            boolean first = true;
            for (Integer succ : conjSuccessors) {
                if (!first) {
                    this.out.write("&");
                }
                first = false;
                this.out.write(succ.toString());
            }
            if (accSignature != null && !accSignature.isEmpty()) {
                this.out.write(" {");
                first = true;
                for (Integer acc : accSignature) {
                    if (!first) {
                        this.out.write(" ");
                    }
                    first = false;
                    this.out.write(acc.toString());
                }
                this.out.write("}");
            }
            this.out.newLine();
        }
        catch (IOException e) {
            throw new HOAConsumerException(e.toString());
        }
    }

    public void addEdgeWithLabel(int stateId, BooleanExpression<AtomLabel> labelExpr, List<Integer> conjSuccessors, @Nullable List<Integer> accSignature) throws HOAConsumerException {
        try {
            if (labelExpr != null) {
                this.out.write("[");
                this.out.write(labelExpr.toString());
                this.out.write("] ");
            }
            boolean first = true;
            for (Integer succ : conjSuccessors) {
                if (!first) {
                    this.out.write("&");
                }
                first = false;
                this.out.write(succ.toString());
            }
            if (accSignature != null && !accSignature.isEmpty()) {
                this.out.write(" {");
                first = true;
                for (Integer acc : accSignature) {
                    if (!first) {
                        this.out.write(" ");
                    }
                    first = false;
                    this.out.write(acc.toString());
                }
                this.out.write("}");
            }
            this.out.newLine();
        }
        catch (IOException e) {
            throw new HOAConsumerException(e.toString());
        }
    }

    public void notifyEndOfState(int stateId) {
    }

    public void notifyEnd() throws HOAConsumerException {
        try {
            this.out.write("--END--");
            this.out.newLine();
            this.out.flush();
        }
        catch (IOException e) {
            throw new HOAConsumerException(e.toString());
        }
    }

    public void notifyAbort() {
        try {
            this.out.write("--ABORT--");
            this.out.newLine();
            this.out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String quoteString(String s) {
        return String.format("\"%s\"", PATTERN_2.matcher(PATTERN_1.matcher(s).replaceAll("\\\\")).replaceAll("\\\""));
    }

    public void notifyWarning(String warning) throws HOAConsumerException {
        throw new HOAConsumerException(warning);
    }
}

