/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.extensions;

import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.extensions.AutoValue_ToStateAcceptanceFixed_StateWithAcceptance;
import jhoafparser.storage.StoredAutomaton;
import jhoafparser.storage.StoredAutomatonManipulator;
import jhoafparser.storage.StoredEdgeImplicit;
import jhoafparser.storage.StoredEdgeWithLabel;
import jhoafparser.storage.StoredHeader;
import jhoafparser.storage.StoredState;

public class ToStateAcceptanceFixed
implements StoredAutomatonManipulator {
    private final StoredAutomaton source;
    private final StoredAutomaton target;
    private final Map<List<Integer>, List<Integer>> uniqueAcceptanceSignatures = new HashMap<List<Integer>, List<Integer>>();
    private final Map<StateWithAcceptance, Integer> transformedStates = new HashMap<StateWithAcceptance, Integer>();
    private final NavigableMap<Integer, StateWithAcceptance> statesForOutput = new TreeMap<Integer, StateWithAcceptance>();

    public ToStateAcceptanceFixed() {
        this.source = null;
        this.target = null;
    }

    private ToStateAcceptanceFixed(StoredAutomaton source) {
        this.source = source;
        this.target = new StoredAutomaton();
    }

    private static StoredHeader fixedStoredHeaderClone(StoredHeader header) {
        StoredHeader clone = header.clone();
        clone.getAcceptanceNames().clear();
        header.getAcceptanceNames().forEach(x -> clone.provideAcceptanceName(x.name, (List)x.extra));
        clone.getMiscHeaders().clear();
        header.getMiscHeaders().forEach(x -> clone.addMiscHeader(x.name, (List)x.extra));
        return clone;
    }

    private void handleHeader() {
        this.target.setStoredHeader(ToStateAcceptanceFixed.fixedStoredHeaderClone(this.source.getStoredHeader()));
        Iterator it = this.target.getStoredHeader().getProperties().iterator();
        block24: while (it.hasNext()) {
            String property;
            switch (property = (String)it.next()) {
                case "trans-acc": {
                    it.remove();
                    continue block24;
                }
                case "state-acc": {
                    continue block24;
                }
                case "state-labels": 
                case "trans-labels": 
                case "implicit-labels": 
                case "explicit-labels": 
                case "univ-branch": 
                case "no-univ-branch": 
                case "deterministic": 
                case "complete": 
                case "unambiguous": 
                case "stutter-invariant": 
                case "weak": 
                case "very-weak": 
                case "inherently-weak": 
                case "terminal": 
                case "tight": {
                    continue block24;
                }
            }
            it.remove();
        }
        this.target.getStoredHeader().getProperties().add("state-acc");
        this.target.getStoredHeader().getMiscHeaders().removeIf(x -> !x.name.startsWith("owl"));
    }

    private void handleStartStates() {
        this.target.getStoredHeader().getStartStates().clear();
        for (List start : this.source.getStoredHeader().getStartStates()) {
            ArrayList<Integer> transformed = new ArrayList<Integer>();
            for (Integer s : start) {
                transformed.add(this.handleState(s, List.of()));
            }
            this.target.getStoredHeader().addStartStates(transformed);
        }
    }

    private void handleTransitionStructure() throws HOAConsumerException {
        while (!this.statesForOutput.isEmpty()) {
            List<Integer> conjSuccessors;
            Map.Entry<Integer, StateWithAcceptance> e = this.statesForOutput.firstEntry();
            this.statesForOutput.remove(e.getKey());
            int stateId = e.getKey();
            StateWithAcceptance sTransformed = Objects.requireNonNull(e.getValue());
            StoredState storedState = this.source.getStoredState(sTransformed.originalStateId());
            List accSignatureState = storedState.getAccSignature();
            this.target.addState(new StoredState(stateId, storedState.getInfo(), storedState.getLabelExpr(), sTransformed.acceptanceSignature()));
            if (this.source.hasEdgesImplicit(sTransformed.originalStateId())) {
                if (this.source.hasEdgesWithLabel(sTransformed.originalStateId())) {
                    throw new HOAConsumerException("Mixed explicit and implicit edges");
                }
                for (StoredEdgeImplicit edge : this.source.getEdgesImplicit(sTransformed.originalStateId())) {
                    conjSuccessors = this.transformSuccessors(edge.getConjSuccessors(), accSignatureState, edge.getAccSignature());
                    this.target.addEdgeImplicit(stateId, new StoredEdgeImplicit(conjSuccessors, null));
                }
                continue;
            }
            if (!this.source.hasEdgesWithLabel(sTransformed.originalStateId())) continue;
            for (StoredEdgeImplicit edge : this.source.getEdgesWithLabel(sTransformed.originalStateId())) {
                conjSuccessors = this.transformSuccessors(edge.getConjSuccessors(), accSignatureState, edge.getAccSignature());
                this.target.addEdgeWithLabel(stateId, new StoredEdgeWithLabel(edge.getLabelExpr(), conjSuccessors, null));
            }
        }
    }

    private List<Integer> transformSuccessors(List<Integer> conjSuccessors, @Nullable List<Integer> accSignatureState, @Nullable List<Integer> accSignatureEdge) {
        List<Integer> accSignature;
        if (accSignatureState == null || accSignatureEdge == null) {
            accSignature = accSignatureEdge == null ? accSignatureState : accSignatureEdge;
        } else {
            accSignature = new ArrayList<Integer>(accSignatureState);
            accSignature.addAll(accSignatureEdge);
        }
        List<Integer> acceptanceSignature = this.handleAcceptanceSignature(accSignature);
        ArrayList<Integer> transformed = new ArrayList<Integer>(conjSuccessors.size());
        for (int successor : conjSuccessors) {
            transformed.add(this.handleState(successor, acceptanceSignature));
        }
        return transformed;
    }

    private int handleState(int stateId, List<Integer> accSignature) {
        return this.transformedStates.computeIfAbsent(StateWithAcceptance.of(stateId, accSignature), sTransformed -> {
            int id = this.transformedStates.size();
            this.statesForOutput.put(id, (StateWithAcceptance)sTransformed);
            return id;
        });
    }

    private List<Integer> handleAcceptanceSignature(@Nullable List<Integer> accSignature) {
        if (accSignature == null || accSignature.isEmpty()) {
            return List.of();
        }
        Object[] copiedAccSignature = (Integer[])accSignature.toArray(Integer[]::new);
        Arrays.sort(copiedAccSignature);
        List<Object> sortedAccSignature = List.of(copiedAccSignature);
        return this.uniqueAcceptanceSignatures.computeIfAbsent(sortedAccSignature, Function.identity());
    }

    private boolean hasTransitionAcceptance() {
        int numStates = this.source.getNumberOfStates();
        for (int state = 0; state <= numStates; ++state) {
            if (this.source.hasEdgesImplicit(state)) {
                for (StoredEdgeImplicit edge : this.source.getEdgesImplicit(state)) {
                    if (edge.getAccSignature() == null || edge.getAccSignature().isEmpty()) continue;
                    return true;
                }
            }
            if (!this.source.hasEdgesWithLabel(state)) continue;
            for (StoredEdgeImplicit edge : this.source.getEdgesWithLabel(state)) {
                if (edge.getAccSignature() == null || edge.getAccSignature().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private StoredAutomaton transform() throws HOAConsumerException {
        if (!this.hasTransitionAcceptance()) {
            this.source.getStoredHeader().getProperties().remove("trans-acc");
            this.source.getStoredHeader().getProperties().add("state-acc");
            return this.source;
        }
        this.handleHeader();
        this.handleStartStates();
        this.handleTransitionStructure();
        this.target.getStoredHeader().setNumberOfStates(Integer.valueOf(this.target.getNumberOfStates()));
        return this.target;
    }

    public StoredAutomaton manipulate(StoredAutomaton automaton) throws HOAConsumerException {
        return new ToStateAcceptanceFixed(automaton).transform();
    }

    @AutoValue
    static abstract class StateWithAcceptance {
        StateWithAcceptance() {
        }

        abstract int originalStateId();

        abstract List<Integer> acceptanceSignature();

        static StateWithAcceptance of(int originalStateId, List<Integer> acceptanceSignature) {
            return new AutoValue_ToStateAcceptanceFixed_StateWithAcceptance(originalStateId, List.copyOf(acceptanceSignature));
        }
    }
}

