/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.BiConsumer;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.AutoValue_AutomatonUtil_LimitDeterministicGeneralizedBuchiAutomaton;
import owl.automaton.Automaton;
import owl.automaton.Views;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.algorithm.LanguageEmptiness;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.bdd.BddSet;
import owl.collections.ImmutableBitSet;

public final class AutomatonUtil {
    private AutomatonUtil() {
    }

    public static <S> void forEachNonTransientEdge(Automaton<S, ?> automaton, BiConsumer<S, Edge<S>> action) {
        List<Set<S>> sccs = SccDecomposition.of(automaton).sccsWithoutTransient();
        for (Set scc : sccs) {
            for (Object state : scc) {
                automaton.edges(state).forEach(edge -> {
                    if (scc.contains(edge.successor())) {
                        action.accept(state, (Edge)edge);
                    }
                });
            }
        }
    }

    public static <S> Map<S, BddSet> getIncompleteStates(Automaton<S, ?> automaton) {
        HashMap<S, BddSet> incompleteStates = new HashMap<S, BddSet>();
        for (S state : automaton.states()) {
            BddSet union = automaton.factory().of(false);
            for (BddSet valuationSet : automaton.edgeMap(state).values()) {
                union = union.union(valuationSet);
            }
            if (union.isUniverse()) continue;
            incompleteStates.put(state, union.complement());
        }
        return incompleteStates;
    }

    public static <S> Set<S> getNondeterministicStates(Automaton<S, ?> automaton) {
        HashSet<S> nondeterministicStates = new HashSet<S>();
        for (S state : automaton.states()) {
            if (!automaton.edgeTree(state).values().stream().anyMatch(x -> x.size() > 1)) continue;
            nondeterministicStates.add(state);
        }
        return nondeterministicStates;
    }

    public static <S> ImmutableBitSet getAcceptanceSets(Automaton<S, ?> automaton, Set<S> states) {
        ImmutableBitSet colours = ImmutableBitSet.of();
        for (S state : states) {
            for (Edge<S> edge : automaton.edges(state)) {
                colours = colours.union(edge.colours());
            }
        }
        return colours;
    }

    public static <S> ImmutableBitSet getAcceptanceSets(Automaton<S, ?> automaton) {
        return AutomatonUtil.getAcceptanceSets(automaton, automaton.states());
    }

    public static <S, B extends GeneralizedBuchiAcceptance> Optional<LimitDeterministicGeneralizedBuchiAutomaton<S, ? extends B>> ldbaSplit(Automaton<S, ? extends B> automaton) {
        HashSet<S> acceptingSccs = new HashSet<S>();
        for (Set<S> scc : SccDecomposition.of(automaton).sccs()) {
            Automaton<Object, ? extends B> sccAutomaton = Views.filtered(automaton, Views.Filter.of(Set.of(scc.iterator().next()), scc::contains));
            if (LanguageEmptiness.isEmpty(sccAutomaton)) continue;
            acceptingSccs.addAll(scc);
        }
        Automaton<S, B> acceptingComponentAutomaton = Views.replaceInitialStates(automaton, acceptingSccs);
        if (!acceptingComponentAutomaton.is(Automaton.Property.SEMI_DETERMINISTIC)) {
            return Optional.empty();
        }
        Sets.SetView initialComponent = Sets.difference(automaton.states(), acceptingComponentAutomaton.states());
        return Optional.of(LimitDeterministicGeneralizedBuchiAutomaton.of(automaton, initialComponent));
    }

    public static <S> boolean isLessOrEqual(Automaton<S, ?> automaton, int numberOfStates) {
        if (automaton instanceof AbstractMemoizingAutomaton) {
            return AutomatonUtil.isLessOrEqual((AbstractMemoizingAutomaton)automaton, numberOfStates);
        }
        ArrayDeque<S> workList = new ArrayDeque<S>(automaton.initialStates());
        HashSet<S> visitedStates = new HashSet<S>(automaton.initialStates());
        Preconditions.checkArgument((numberOfStates >= 0 ? 1 : 0) != 0);
        while (!workList.isEmpty()) {
            if (visitedStates.size() > numberOfStates) {
                return false;
            }
            Object state = workList.remove();
            for (S successor : automaton.successors(state)) {
                if (!visitedStates.add(successor)) continue;
                workList.add(successor);
            }
        }
        return true;
    }

    public static <S> boolean isLessOrEqual(AbstractMemoizingAutomaton<S, ?> automaton, int numberOfStates) {
        Preconditions.checkArgument((numberOfStates >= 0 ? 1 : 0) != 0);
        PriorityQueue<Object> workList = new PriorityQueue<Object>(numberOfStates + 1, Comparator.comparing(automaton::edgeTreePrecomputed).reversed());
        HashSet<S> visitedStates = new HashSet<S>(numberOfStates + 1);
        workList.addAll(automaton.initialStates);
        visitedStates.addAll(automaton.initialStates);
        while (!workList.isEmpty()) {
            if (visitedStates.size() > numberOfStates) {
                return false;
            }
            Object state = workList.remove();
            for (S successor : automaton.successors(state)) {
                if (!visitedStates.add(successor)) continue;
                workList.add(successor);
            }
        }
        return true;
    }

    @AutoValue
    public static abstract class LimitDeterministicGeneralizedBuchiAutomaton<S, B extends GeneralizedBuchiAcceptance> {
        public abstract Automaton<S, B> automaton();

        public abstract Set<S> initialComponent();

        public static <S, B extends GeneralizedBuchiAcceptance> LimitDeterministicGeneralizedBuchiAutomaton<S, B> of(Automaton<S, B> automaton, Set<S> initialComponent) {
            return new AutoValue_AutomatonUtil_LimitDeterministicGeneralizedBuchiAutomaton<S, B>(automaton, Set.copyOf(initialComponent));
        }
    }
}

